---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：46-Task（コルーチン）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **C-16: Task 作成のコスト**：ナノ秒/マイクロ秒の見積もりは一般知識に基づく
  2. **C-17: C ランタイムのファイル名**：task.c / scheduler.c の正確なファイル名
  3. **C-18: 行番号の正確性**：推定値であり変動の可能性あり

## 2) 参照した情報（Evidence一覧）

- E-01: `base/task.jl` ソースコード全体
- E-02: `base/task.jl` Task 操作関数（schedule, wait, fetch, yield）
- E-03: `base/task.jl` istaskdone/istaskfailed/istaskstarted
- E-04: `base/task.jl` @async マクロ定義
- E-05: `base/task.jl` @sync マクロ定義
- E-06: `base/task.jl` task_local_storage 関数定義
- E-07: `base/condition.jl` GenericCondition / _wait2 の定義
- E-08: `base/lock.jl` ReentrantLock の定義
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` 機能No.46の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Task は base/task.jl に実装されている | E-01, E-09 | ○ |
| C-02 | Task(f) で関数をラップしたコルーチンを生成する | E-01 | ○ |
| C-03 | schedule(t) でランタイムキューに追加する | E-02 | ○ |
| C-04 | wait(t) はタスクの完了を待つ | E-02 | ○ |
| C-05 | fetch(t) は結果を取得する | E-02 | ○ |
| C-06 | yield() で制御を譲渡する | E-02 | ○ |
| C-07 | istaskdone/istaskfailed/istaskstarted でタスク状態を確認できる | E-03 | ○ |
| C-08 | @async は Task + schedule をワンステップで行う | E-04 | ○ |
| C-09 | @sync は全 @async タスクの完了を待つ | E-05 | ○ |
| C-10 | task_local_storage はタスクローカルデータを管理する | E-06 | ○ |
| C-11 | sticky=true のタスクは作成スレッドに固定される | E-01 | ○ |
| C-12 | fetch は失敗タスクの例外を再 throw する | E-02 | ○ |
| C-13 | wait は失敗を TaskFailedException でラップする | E-02 | ○ |
| C-14 | @sync は CompositeException を throw する | E-05 | ○ |
| C-15 | current_task() は ccall :jl_get_current_task を呼ぶ | E-01 | ○ |
| C-16 | Task 作成は数百ナノ秒〜マイクロ秒オーダー | **根拠なし** | △ |
| C-17 | C ランタイム実装のファイルが task.c / scheduler.c である | **根拠なし** | △ |
| C-18 | コードリーディングガイドの行番号が正確である | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Task 作成コストの具体的なベンチマーク値
  - 候補：Julia ベンチマーク / 公式ドキュメントの性能指標
- C ランタイムのファイル構成（task.c 等の正確な名称・配置）
  - 候補：src/ ディレクトリの確認
- コードリーディングガイドの行番号
  - 候補：最新ソースとの照合

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Task のデータ競合防止はユーザー責任であり、ドキュメントでの注意喚起が重要
- 0: 低リスク - Task の基本操作は安定した API

## 6) レビュアーチェックリスト（最小）
- [ ] Task の sticky フラグの説明が正確か
- [ ] @async/@sync の動作が正しく記述されているか
- [ ] TaskFailedException と CompositeException の使い分けが正確か
- [ ] task_local_storage のスコープとアクセス制限が正確か
- [ ] C ランタイムのファイル名・パスが正確か
