---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 19
  claims_with_evidence: 17
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：47-マルチスレッド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：17 / 19、根拠なし：2
- 優先レビュー（高）
  1. **C-18: @threads のオーバーヘッド見積もり**：マイクロ秒単位の見積もりは推定
  2. **C-19: 10マイクロ秒の閾値**：並列化効果の閾値は一般的な目安

## 2) 参照した情報（Evidence一覧）

- E-01: `base/threadingconstructs.jl` ソースコード全体（544行）
- E-02: `base/threadingconstructs.jl` 1-7行目 export 宣言
- E-03: `base/threadingconstructs.jl` 36行目 threadid()
- E-04: `base/threadingconstructs.jl` 47行目 maxthreadid()
- E-05: `base/threadingconstructs.jl` 60行目 nthreads(pool)
- E-06: `base/threadingconstructs.jl` 96-99行目 threadpool(tid)
- E-07: `base/threadingconstructs.jl` 136-145行目 threadpoolsize(pool)
- E-08: `base/threadingconstructs.jl` 169行目 ngcthreads()
- E-09: `base/threadingconstructs.jl` 171-201行目 threading_run
- E-10: `base/threadingconstructs.jl` 226-241行目 greedy_func
- E-11: `base/threadingconstructs.jl` 243-284行目 default_func
- E-12: `base/threadingconstructs.jl` 413-439行目 @threads マクロ
- E-13: `base/threadingconstructs.jl` 495-535行目 @spawn マクロ
- E-14: `base/threadingconstructs.jl` 441-449行目 _spawn_set_thrpool
- E-15: `docs/code-to-docs/機能一覧/機能一覧.csv` 機能No.47の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | マルチスレッド機能は base/threadingconstructs.jl に実装 | E-01, E-15 | ○ |
| C-02 | @threads は :default プールのスレッドを使用する | E-09 | ○ |
| C-03 | :static は @threads のネスト使用が禁止 | E-12 | ○ |
| C-04 | デフォルトのスケジュールは :dynamic | E-12 | ○ |
| C-05 | @spawn はデフォルトで :default プールに割当 | E-13 | ○ |
| C-06 | threadid() は ccall :jl_threadid で取得 | E-03 | ○ |
| C-07 | maxthreadid() は atomic_pointerref で取得 | E-04 | ○ |
| C-08 | threadpool は :default, :interactive, :foreign の3種類 | E-06 | ○ |
| C-09 | ngcthreads() で GC スレッド数を取得 | E-08 | ○ |
| C-10 | threading_run はスレッド数分の Task を作成する | E-09 | ○ |
| C-11 | :greedy は Channel でアイテムを分配する | E-10 | ○ |
| C-12 | :dynamic/:static は divrem でイテレーション分割 | E-11 | ○ |
| C-13 | 失敗タスクは CompositeException で報告される | E-09 | ○ |
| C-14 | @spawn は sticky=false でタスクを作成する | E-13 | ○ |
| C-15 | _spawn_set_thrpool でプール ID を設定する | E-14 | ○ |
| C-16 | :greedy は Julia 1.11 で追加された | E-10 | ○ |
| C-17 | @spawn は @sync 変数に登録する | E-13 | ○ |
| C-18 | @threads のオーバーヘッドは数マイクロ秒〜数十マイクロ秒 | **根拠なし** | △ |
| C-19 | 反復ごとの処理時間が10マイクロ秒以上で並列化効果がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- @threads の具体的なオーバーヘッド（ベンチマーク値）
  - 候補：Julia 公式ドキュメント / ベンチマーク
- 並列化効果の閾値は公式ドキュメントの推奨値に基づく推定
  - 候補：@threads の docstring（10 microseconds の記載あり）

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - データ競合の防止はユーザー責任であり、注意喚起が重要
- 0: 低リスク - スレッド情報取得関数は読み取り専用で安全

## 6) レビュアーチェックリスト（最小）
- [ ] 3種類のスケジューリング方式（:dynamic, :static, :greedy）の動作が正確か
- [ ] @spawn のスレッドプール指定オプションが正確か
- [ ] threading_run の内部動作（Task 作成、schedule、wait）が正しいか
- [ ] イテレーション分割ロジック（divrem）が正確に記述されているか
- [ ] タスクマイグレーションに関する注意事項が適切か
