---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：49-同期プリミティブ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **C-21: lock/unlock のパフォーマンス見積もり**：ナノ秒の見積もりは推定値
  2. **C-22: SpinLock の30スレッド制限**：docstring に基づくが具体的根拠は不足

## 2) 参照した情報（Evidence一覧）

- E-01: `base/lock.jl` ソースコード全体（992行）
- E-02: `base/lock.jl` 48-86行目 ReentrantLock 構造体定義
- E-03: `base/lock.jl` 165-183行目 trylock(ReentrantLock)
- E-04: `base/lock.jl` 194-246行目 lock(ReentrantLock) slowlock
- E-05: `base/lock.jl` 269-302行目 unlock(ReentrantLock)
- E-06: `base/lock.jl` 371-381行目 @lock マクロ
- E-07: `base/lock.jl` 425-431行目 Lockable 構造体
- E-08: `base/lock.jl` 457-494行目 Threads.Condition 定義
- E-09: `base/lock.jl` 505-510行目 Semaphore 定義
- E-10: `base/lock.jl` 518-529行目 acquire
- E-11: `base/lock.jl` 601-611行目 release
- E-12: `base/lock.jl` 633-638行目 Event 定義
- E-13: `base/lock.jl` 640-675行目 wait/notify(Event)
- E-14: `base/lock.jl` 729-776行目 OncePerProcess
- E-15: `base/lock.jl` 842-947行目 OncePerThread
- E-16: `base/lock.jl` 980-991行目 OncePerTask
- E-17: `base/locks-mt.jl` ソースコード全体（111行）
- E-18: `base/locks-mt.jl` 41-45行目 SpinLock 定義
- E-19: `base/locks-mt.jl` 60-70行目 PaddedSpinLock 定義
- E-20: `base/locks-mt.jl` 76-106行目 lock/trylock/unlock(SpinLock)
- E-21: `base/condition.jl` ソースコード全体（205行）
- E-22: `base/condition.jl` 63-70行目 GenericCondition 定義
- E-23: `base/condition.jl` 136-148行目 wait(GenericCondition)
- E-24: `base/condition.jl` 159-170行目 notify(GenericCondition)
- E-25: `docs/code-to-docs/機能一覧/機能一覧.csv` 機能No.49の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ReentrantLock は再入可能なロックである | E-02, E-03 | ○ |
| C-02 | ReentrantLock は LOCKED_BIT と PARKED_BIT の2ビットで状態管理 | E-02 | ○ |
| C-03 | trylock は CAS でアトミックにロックを取得する | E-03 | ○ |
| C-04 | lock はスピン（40回）→ パーク → wait のフローで動作する | E-04 | ○ |
| C-05 | unlock は reentrancy_cnt デクリメントで再入を管理する | E-05 | ○ |
| C-06 | lock 中はファイナライザが無効化される | E-03 | ○ |
| C-07 | SpinLock は test-and-test-and-set アルゴリズムである | E-17, E-20 | ○ |
| C-08 | PaddedSpinLock は64バイトのキャッシュラインパディングを持つ | E-19 | ○ |
| C-09 | GenericCondition は waitq と lock で構成される | E-22 | ○ |
| C-10 | wait は unlockall → suspend → relockall のフローで動作する | E-23 | ○ |
| C-11 | notify は waitq から popfirst! → schedule する | E-24 | ○ |
| C-12 | Threads.Condition は ReentrantLock ベースの GenericCondition | E-08 | ○ |
| C-13 | Base.Condition はスレッドセーフではない | E-21 | ○ |
| C-14 | Semaphore は sem_size, curr_cnt, cond_wait で構成される | E-09 | ○ |
| C-15 | Event は autoreset オプションを持つ | E-12 | ○ |
| C-16 | Event の notify は autoreset ? 1人 : 全員 | E-13 | ○ |
| C-17 | OncePerProcess は PerStateHasrun まで一度だけ初期化する | E-14 | ○ |
| C-18 | OncePerThread は AtomicMemory でスレッドごとの状態管理 | E-15 | ○ |
| C-19 | OncePerTask は task_local_storage を使用する | E-16 | ○ |
| C-20 | @lock マクロは try-finally で unlock を保証する | E-06 | ○ |
| C-21 | lock/unlock は競合なしでナノ秒オーダー | **根拠なし** | △ |
| C-22 | SpinLock は約30スレッドまで効率的 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- lock/unlock のパフォーマンスベンチマーク
  - 候補：Julia マイクロベンチマーク / 公式ドキュメント
- SpinLock の30スレッド制限の根拠（docstring には記載あり）
  - 候補：base/locks-mt.jl の docstring 確認

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - デッドロック/ライブロックの可能性に関する注意喚起が重要
- 1: 中リスク - OncePerProcess の初期化失敗時の永続エラー状態
- 0: 低リスク - @lock マクロによる安全なロック管理パターン

## 6) レビュアーチェックリスト（最小）
- [ ] ReentrantLock の LOCKED_BIT/PARKED_BIT の状態遷移が正確か
- [ ] trylock の CAS 操作のメモリオーダリングが正しく記述されているか
- [ ] SpinLock と ReentrantLock の使い分け指針が適切か
- [ ] Condition の wait/notify のロック要件が正確か
- [ ] Event の autoreset 動作が正確か
- [ ] OncePerProcess/Thread/Task の状態遷移が正確か
