---
generated_at: 2026-02-04 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：50-非同期イベント

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **C-19: Timer の精度見積もり**：1-15ms という見積もりは OS 依存で変動
  2. **C-20: AsyncCondition の通知速度**：マイクロ秒の見積もりは推定値

## 2) 参照した情報（Evidence一覧）

- E-01: `base/asyncevent.jl` ソースコード全体（433行）
- E-02: `base/asyncevent.jl` 17-39行目 AsyncCondition 構造体定義
- E-03: `base/asyncevent.jl` 47-66行目 AsyncCondition(cb) コールバック版
- E-04: `base/asyncevent.jl` 109-139行目 Timer 構造体定義
- E-05: `base/asyncevent.jl` 140-150行目 Timer の getproperty（timeout/interval プロパティ）
- E-06: `base/asyncevent.jl` 164-200行目 _trywait
- E-07: `base/asyncevent.jl` 202-205行目 wait
- E-08: `base/asyncevent.jl` 218-246行目 close
- E-09: `base/asyncevent.jl` 248-266行目 uvfinalize
- E-10: `base/asyncevent.jl` 268-280行目 _uv_hook_close
- E-11: `base/asyncevent.jl` 282-292行目 uv_asynccb
- E-12: `base/asyncevent.jl` 294-311行目 uv_timercb
- E-13: `base/asyncevent.jl` 319-323行目 sleep
- E-14: `base/asyncevent.jl` 363-390行目 Timer(cb, ...)
- E-15: `base/asyncevent.jl` 414-432行目 timedwait
- E-16: `docs/code-to-docs/機能一覧/機能一覧.csv` 機能No.50の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 非同期イベントは base/asyncevent.jl に実装されている | E-01, E-16 | ○ |
| C-02 | AsyncCondition は uv_async_init で libuv に登録する | E-02 | ○ |
| C-03 | Timer は uv_timer_init + uv_timer_start で開始する | E-04 | ○ |
| C-04 | Timer の timeout に +1ms 補正がある | E-04 | ○ |
| C-05 | _trywait は Timer/AsyncCondition 共通の待機関数 | E-06 | ○ |
| C-06 | _trywait は set フラグ確認 → iolock → cond wait の順で動作 | E-06 | ○ |
| C-07 | wait は _trywait のラッパーで false なら EOFError | E-07 | ○ |
| C-08 | uv_asynccb は set=true に設定し notify する | E-11 | ○ |
| C-09 | uv_timercb は set=true、repeat==0 なら close | E-12 | ○ |
| C-10 | sleep は Timer(sec) + wait で実装されている | E-13 | ○ |
| C-11 | timedwait は pollint 間隔のタイマーでポーリングする | E-15 | ○ |
| C-12 | timedwait は :ok または :timed_out を返す | E-15 | ○ |
| C-13 | Timer(cb, ...) はコールバックを _trywait ループで繰り返す | E-14 | ○ |
| C-14 | close は isopen=false → jl_close_uv → handle NULL 待ち | E-08 | ○ |
| C-15 | uvfinalize は GC ファイナライザとして libuv ハンドルを解放する | E-09 | ○ |
| C-16 | Timer の timeout/interval プロパティが読み取り可能 | E-05 | ○ |
| C-17 | pollint は最低 0.001 秒 | E-15 | ○ |
| C-18 | Timer の spawn オプションは親タスクの sticky に依存 | E-14 | ○ |
| C-19 | Timer の精度は 1-15ms 程度 | **根拠なし** | △ |
| C-20 | AsyncCondition の通知はマイクロ秒オーダー | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Timer の精度に関する具体的なベンチマーク値（OS / ハードウェア依存）
  - 候補：libuv ドキュメント / OS タイマー精度のドキュメント
- AsyncCondition の通知速度のベンチマーク
  - 候補：Julia マイクロベンチマーク

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - sleep / timedwait は安定した API
- 1: 中リスク - AsyncCondition の C 連携は libuv の正しい使用が前提
- 0: 低リスク - Timer は自動 close で安全

## 6) レビュアーチェックリスト（最小）
- [ ] AsyncCondition の libuv 初期化手順が正確か
- [ ] Timer の +1ms 補正ロジックが正しく記述されているか
- [ ] _trywait の set フラグリセットタイミングが正確か
- [ ] close のハンドル解放手順が正確か
- [ ] timedwait のポーリングロジックが正確か
- [ ] Timer(cb) のコールバック実行とエラーハンドリングが正確か
