---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：51-非同期マッピング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **CPU バウンド処理に不向きとの記述**: ソースコード上に明示的な記載がなく、一般的知識に基づく
  2. **パフォーマンス要件**: 具体的なベンチマーク根拠なし
  3. **BitArray/String 特殊化の詳細動作**: 実装は確認済みだが網羅的なテストケースは未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `base/asyncmap.jl` 76-78行目（asyncmap 関数定義）
- E-02: `base/asyncmap.jl` 80-100行目（async_usemap 関数定義）
- E-03: `base/asyncmap.jl` 116-130行目（verify_ntasks 関数）
- E-04: `base/asyncmap.jl` 103-113行目（verify_batch_size 関数）
- E-05: `base/asyncmap.jl` 187-206行目（setup_chnl_and_tasks 関数）
- E-06: `base/asyncmap.jl` 208-240行目（start_worker_task! 関数）
- E-07: `base/asyncmap.jl` 132-150行目（wrap_n_exec_twice 関数）
- E-08: `base/asyncmap.jl` 152-185行目（maptwice 関数）
- E-09: `base/asyncmap.jl` 258-267行目（AsyncCollector 構造体）
- E-10: `base/asyncmap.jl` 293-299行目（AsyncCollectorState 構造体）
- E-11: `base/asyncmap.jl` 349-351行目（AsyncGenerator 構造体）
- E-12: `base/asyncmap.jl` 357-362行目（AsyncGeneratorState 構造体）
- E-13: `base/asyncmap.jl` 402-405行目（asyncmap! 関数定義）
- E-14: `base/asyncmap.jl` 243-256行目（String/BitArray 特殊化）
- E-15: `base/asyncmap.jl` 5-75行目（asyncmap docstring）
- E-16: `docs/code-to-docs/機能一覧/機能一覧.csv` 51行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | asyncmap は async_usemap に委譲する | E-01 | ○ |
| C-02 | ntasks=0 の場合 min(100, length(c)) タスクが使用される | E-03 | ○ |
| C-03 | ntasks は 0 引数関数も指定可能 | E-03, E-15 | ○ |
| C-04 | batch_size は正の整数であること | E-04 | ○ |
| C-05 | Channel は無バッファ（サイズ 0）で生成される | E-05 | ○ |
| C-06 | ワーカータスクは @async で起動される | E-06 | ○ |
| C-07 | バッチモード時はバッチ収集後に exec_func を呼び出す | E-06 | ○ |
| C-08 | 2パスマッピング（Ref 生成 + 結果抽出） | E-07, E-08 | ○ |
| C-09 | 出力は入力の順序を保持する | E-15 | ○ |
| C-10 | ワーカータスク例外時に Channel が close される | E-06 | ○ |
| C-11 | AsyncCollector は mutable struct | E-09 | ○ |
| C-12 | AsyncGenerator は AsyncCollector をラップする | E-11 | ○ |
| C-13 | asyncmap! は AsyncCollector を foreach で消費 | E-13 | ○ |
| C-14 | String 入力時は Vector{Char} に変換して処理 | E-14 | ○ |
| C-15 | BitArray 入力で Bool 結果時は BitArray を返す | E-14 | ○ |
| C-16 | 動的タスク数では毎要素処理前にチェック | E-07 | ○ |
| C-17 | haslength がない場合は ntasks=100 | E-03 | ○ |
| C-18 | 結果受け渡しに Ref{Any} を使用 | E-07, E-08 | ○ |
| C-19 | capture_exception でワーカータスクの例外を保持 | E-06 | ○ |
| C-20 | CPU バウンド処理には不向き | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20: CPU バウンド処理に不向きとの記述はソースコードに明記されていない。Julia の GIL に相当する制約はないが、asyncmap がグリーンスレッドベースであるため CPU バウンド処理では yield が発生せずパフォーマンス向上が限定的という一般的知識に基づく。
  - 候補：公式ドキュメント / パフォーマンスガイド / テストベンチマーク

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードから直接確認可能な内容で構成されている
- 1: 中リスク - パフォーマンス特性に関する記述は実測に基づいていない

## 6) レビュアーチェックリスト（最小）
- [ ] asyncmap のデフォルトタスク数ロジック（min(100, length)）が正確か確認
- [ ] バッチモードでの f の引数/返り値仕様が正確か確認
- [ ] エラー伝播のメカニズム（Channel close + fetch での例外再 throw）が正確か確認
- [ ] CPU バウンドに不向きとの記述の妥当性を確認
