---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：52-アトミック操作

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Atomic{T}の型制約**: プリミティブ型に限定されるかの厳密な確認
  2. **LLVM命令へのマッピング詳細**: C/C++ランタイム層の確認が必要
  3. **非対称フェンスのOS対応**: プラットフォーム依存の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `base/atomics.jl` 41-45行目（Atomic{T} 構造体定義）
- E-02: `base/atomics.jl` 304-315行目（アトミック演算実装）
- E-03: `base/atomics.jl` 332-356行目（メモリフェンス関数）
- E-04: `base/atomics.jl` 56-88行目（atomic_cas! docstring）
- E-05: `base/atomics.jl` 115-137行目（atomic_add! docstring）
- E-06: `base/expr.jl` 1303-1430行目（@atomic マクロ定義）
- E-07: `base/expr.jl` 1431-1484行目（make_atomic 関数）
- E-08: `base/expr.jl` 1534-1553行目（@atomicswap 実装）
- E-09: `base/expr.jl` 1629-1663行目（@atomicreplace 実装）
- E-10: `base/expr.jl` 1732-1756行目（@atomiconce 実装）
- E-11: `docs/code-to-docs/機能一覧/機能一覧.csv` 52行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Atomic{T} は mutable struct で @atomic value フィールドを持つ | E-01 | ○ |
| C-02 | デフォルトコンストラクタはゼロ初期化 | E-01 | ○ |
| C-03 | getindex は :acquire セマンティクスで実装 | E-02 | ○ |
| C-04 | setindex! は :release セマンティクスで実装 | E-02 | ○ |
| C-05 | atomic_cas! は @atomicreplace で実装 | E-02 | ○ |
| C-06 | atomic_add! 等は @atomic modify で実装 | E-02 | ○ |
| C-07 | 演算系関数は旧値を返す | E-04, E-05 | ○ |
| C-08 | デフォルトオーダリングは :sequentially_consistent | E-06 | ○ |
| C-09 | @atomic フィールドアクセスは getproperty に変換 | E-07 | ○ |
| C-10 | @atomic 代入は setproperty! に変換 | E-07 | ○ |
| C-11 | @atomic modify は modifyproperty! に変換 | E-07 | ○ |
| C-12 | @atomicswap は swapproperty! に変換 | E-08 | ○ |
| C-13 | @atomicreplace は replaceproperty! に変換 | E-09 | ○ |
| C-14 | @atomiconce は setpropertyonce! に変換 | E-10 | ○ |
| C-15 | atomic_fence は Core.Intrinsics.atomic_fence を使用 | E-03 | ○ |
| C-16 | atomic_fence_heavy は ccall(:jl_membarrier) を使用 | E-03 | ○ |
| C-17 | 参照アクセスは getindex_atomic 等に変換 | E-07 | ○ |
| C-18 | Atomic{T}のTはプリミティブ型に制限 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: Atomic{T} の型パラメータ T の制約について、ソースコード上では `zero(T)` が呼べる型であれば構築可能だが、LLVM アトミック命令がサポートする型に実質的に制限される。明示的な型制約は未確認。
  - 候補：LLVM ドキュメント / Julia マニュアルの Per-field atomics セクション / C ランタイム実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - マクロ展開ロジックはソースコードから直接確認可能
- 1: 中リスク - LLVM レベルの動作詳細は C/C++ ランタイム層の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] @atomic マクロの 4 つのオーバーロードが正しく文書化されているか
- [ ] メモリオーダリングの種類と意味が正確か
- [ ] Atomic{T} のレガシー API と新 API (@atomic フィールド) の関係が正確か
- [ ] 参照レベルアトミック操作（AtomicMemory）の文書化が十分か
