---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：54-マクロ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **ハイジーン処理の詳細メカニズム**: Cランタイム層の実装確認が必要
  2. **パーサーによるマクロ呼び出しのAST変換**: JuliaSyntax.jl の確認が必要
  3. **マクロ展開の再帰的処理**: lowering フェーズの実装確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `base/expr.jl` 18-23行目（gensym 関数）
- E-02: `base/expr.jl` 31-38行目（@gensym マクロ）
- E-03: `base/expr.jl` 1101-1112行目（pushmeta! 関数）
- E-04: `base/expr.jl` 1179-1205行目（findmeta / findmeta_block）
- E-05: `base/expr.jl` 1167-1177行目（is_function_def）
- E-06: `base/expr.jl` 383-385行目（@inline マクロ）
- E-07: `base/expr.jl` 1284-1300行目（@generated マクロ）
- E-08: `base/expr.jl` 870-892行目（@assume_effects マクロ）
- E-09: `base/boot.jl` 329-330行目（Core レベルマクロ）
- E-10: `base/expr.jl` 1092-1099行目（unwrap_macrocalls）
- E-11: `docs/code-to-docs/機能一覧/機能一覧.csv` 54行目
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（画面No.2, 機能No.54）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | gensym は ccall(:jl_gensym) で一意シンボルを生成 | E-01 | ○ |
| C-02 | @gensym は複数変数に一括で gensym を割り当て | E-02 | ○ |
| C-03 | pushmeta! は :meta 式にタグを追加 | E-03 | ○ |
| C-04 | findmeta は関数定義の :meta 式を検索 | E-04 | ○ |
| C-05 | @inline は annotate_meta_def_or_block を呼ぶ | E-06 | ○ |
| C-06 | @generated は関数定義を条件分岐式に変換 | E-07 | ○ |
| C-07 | unwrap_macrocalls はネストしたマクロ呼び出しを展開 | E-10 | ○ |
| C-08 | Core レベルで @inline/@noinline が定義されている | E-09 | ○ |
| C-09 | @assume_effects はコンパイラ効果アノテーションを付与 | E-08 | ○ |
| C-10 | is_function_def は :function / := / :-> を判定 | E-05 | ○ |
| C-11 | REPL でマクロ展開処理とマクロ補完がサポート | E-12 | ○ |
| C-12 | マクロ引数は未評価の AST として渡される | E-06, E-07 | ○ |
| C-13 | __module__ と __source__ は暗黙引数 | E-06, E-07 | ○ |
| C-14 | ハイジーン処理でマクロ内変数にスコープ情報を付与 | **根拠なし** | △ |
| C-15 | パーサーがマクロ呼び出しを Expr(:macrocall, ...) に変換 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: ハイジーン処理の詳細は C ランタイム（src/ast.c の jl_macroexpand 内）で実装されており、Julia ソースからは直接確認困難。
  - 候補：src/ast.c / src/macroexpand.scm / Julia マニュアルの Metaprogramming セクション
- C-15: パーサーの AST 変換は JuliaSyntax.jl 内部で実装されており、本調査では未確認。
  - 候補：JuliaSyntax/src/ / src/flisp/julia-parser.scm

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - マクロの核心であるハイジーン処理の詳細が C/Flisp 層にあり、Julia ソースからは間接的にしか確認できない
- 0: 低リスク - マクロユーティリティ関数（pushmeta!, findmeta 等）は Julia ソースで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] マクロのハイジーン処理の説明が正確か（C ランタイム実装との整合性）
- [ ] esc() の動作説明が正確か
- [ ] __module__ / __source__ の暗黙引数の説明が正確か
- [ ] パーサーによる Expr(:macrocall, ...) 変換の説明が正確か
