---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：55-式オブジェクト（Expr）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **Expr 型の Core レベル定義の詳細**: boot.jl での型定義の詳細確認
  2. **QuoteNode の $ 補間との相互作用**: パーサー側の実装確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `base/expr.jl` 1行目, 42-43行目（isexpr 関数）
- E-02: `base/expr.jl` 81行目（exprarray）
- E-03: `base/expr.jl` 45行目（copy(::Expr)）
- E-04: `base/expr.jl` 46-55行目（copy(::PhiNode)）
- E-05: `base/expr.jl` 84-97行目（copy(::CodeInfo)）
- E-06: `base/expr.jl` 69-79行目（copy_exprs / copy_exprargs）
- E-07: `base/expr.jl` 135行目（== for Expr）
- E-08: `base/expr.jl` 99-131行目（isequal_exprarg / isequal_exprargs）
- E-09: `base/expr.jl` 1212-1229行目（remove_linenums!）
- E-10: `base/expr.jl` 1769-1789行目（isa_ast_node）
- E-11: `base/expr.jl` 1791行目（is_self_quoting）
- E-12: `base/expr.jl` 1801行目（quoted）
- E-13: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（画面No.2,3,11 機能No.55）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | isexpr は 4 つのオーバーロードを持つ | E-01 | ○ |
| C-02 | exprarray は Expr の内部コンストラクタ | E-02 | ○ |
| C-03 | copy(::Expr) は head と copy_exprargs(args) で新 Expr を生成 | E-03 | ○ |
| C-04 | PhiNode のコピーは未定義要素をハンドリング | E-04 | ○ |
| C-05 | CodeInfo のコピーは ccall + ミュータブルフィールドコピー | E-05 | ○ |
| C-06 | copy_exprs は Expr, PhiNode, PhiCNode を再帰コピー | E-06 | ○ |
| C-07 | Expr の == は head === と args の再帰比較 | E-07 | ○ |
| C-08 | isequal_exprargs は未定義要素のペア比較を処理 | E-08 | ○ |
| C-09 | remove_linenums! は :block/:quote ヘッドの LineNumberNode を除去 | E-09 | ○ |
| C-10 | isa_ast_node は AST/IR 特殊ノード型を判定 | E-10 | ○ |
| C-11 | is_self_quoting は !isa_ast_node | E-11 | ○ |
| C-12 | quoted は AST ノードを QuoteNode でラップ | E-12 | ○ |
| C-13 | REPL, ヘルプモード, フォールバックREPL で Expr が使用される | E-13 | ○ |
| C-14 | Expr は head::Symbol と args::Vector{Any} の 2 フィールド | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: Expr 型の定義は Core（C ランタイム）で行われており、Julia ソースでは直接確認困難。boot.jl で型が参照されているが、フィールド定義自体は C 層。
  - 候補：src/julia.h / src/jltypes.c / Julia マニュアルの Metaprogramming セクション

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - expr.jl の関数は Julia ソースから直接確認可能
- 1: 中リスク - Expr 型自体の定義は C 層にあり間接的確認

## 6) レビュアーチェックリスト（最小）
- [ ] Expr 型のフィールド構成（head, args）が正確か
- [ ] copy の再帰的動作が正確に記述されているか
- [ ] == 比較の挙動（特に未定義要素のハンドリング）が正確か
- [ ] REPL/ヘルプモードでの Expr 使用が画面機能マッピングと整合するか
