---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 13
  claims_with_evidence: 11
  claims_without_evidence: 2
confidence_derived: 0.85
---

# 根拠レポート：56-コード生成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：11 / 13、根拠なし：2
- 優先レビュー（高）
  1. **キャッシュメカニズムの詳細**: C ランタイム層の確認が必要
  2. **GeneratedFunctionStub 型定義**: Core/C 層の確認が必要
  3. **コンパイラパイプラインとの連携詳細**: Compiler/ 層の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `base/expr.jl` 1284-1300行目（@generated マクロ）
- E-02: `base/expr.jl` 1251-1253行目（@generated() 引数なし版）
- E-03: `base/expr.jl` 1804-1827行目（generated_body_to_codeinfo）
- E-04: `base/expr.jl` 1830-1846行目（GeneratedFunctionStub 呼び出し）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` 56行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @generated は関数定義を条件分岐式に変換 | E-01 | ○ |
| C-02 | 条件分岐は Expr(:if, Expr(:generated), body, fallback) | E-01 | ○ |
| C-03 | fallback は :generated_only メタを含む | E-01 | ○ |
| C-04 | @generated() は Expr(:generated) を返す | E-02 | ○ |
| C-05 | generated_body_to_codeinfo は ccall(:jl_fl_lower) で lowering | E-03 | ○ |
| C-06 | GlobalRef から Core.Binding を収集して edges に設定 | E-03 | ○ |
| C-07 | GeneratedFunctionStub は g.gen(args...) で本体実行 | E-04 | ○ |
| C-08 | lambda でラップし :push_loc/:pop_loc メタを付加 | E-04 | ○ |
| C-09 | 静的パラメータは with-static-parameters でラップ | E-04 | ○ |
| C-10 | クロージャ禁止（純粋な式のみ） | E-03 | ○ |
| C-11 | @generated が関数定義以外に適用されるとエラー | E-01 | ○ |
| C-12 | 生成コードは型ごとにキャッシュされる | **根拠なし** | △ |
| C-13 | GeneratedFunctionStub は Core で定義 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12: キャッシュメカニズムは C ランタイム（src/gf.c）で実装されており、Julia ソースからは直接確認困難。
  - 候補：src/gf.c / src/method.c
- C-13: GeneratedFunctionStub 型は Core モジュールで定義されているが、C 層の定義を直接確認していない。
  - 候補：src/julia.h / src/builtins.c

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - @generated の Julia 側実装は確認済みだが、コンパイラとの連携部分は C 層の確認が必要
- 0: 低リスク - @generated マクロの変換ロジック自体は正確に確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] @generated マクロの変換パターンが正確か
- [ ] generated_body_to_codeinfo の処理フローが正確か
- [ ] クロージャ禁止の制約説明が正確か
- [ ] キャッシュメカニズムの説明が正確か
