---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 10
  claims_without_evidence: 2
confidence_derived: 0.83
---

# 根拠レポート：57-マクロ展開

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：10 / 12、根拠なし：2
- 優先レビュー（高）
  1. **jl_macroexpand のCランタイム実装の詳細**: src/ast.c の確認が必要
  2. **ハイジーン処理の詳細メカニズム**: C層の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `base/expr.jl` 180-208行目（macroexpand 関数定義 + docstring）
- E-02: `base/expr.jl` 210-228行目（macroexpand! 関数定義）
- E-03: `base/expr.jl` 273-278行目（@macroexpand マクロ）
- E-04: `base/expr.jl` 285-290行目（@macroexpand1 マクロ）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` 57行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | macroexpand は ccall(:jl_macroexpand) を呼び出す | E-01 | ○ |
| C-02 | macroexpand! は inplace=true で ccall を呼び出す | E-02 | ○ |
| C-03 | @macroexpand は QuoteNode で式をクォートする | E-03 | ○ |
| C-04 | @macroexpand は __module__ で呼び出し元モジュールを使用 | E-03 | ○ |
| C-05 | @macroexpand1 は recursive=false で展開 | E-04 | ○ |
| C-06 | macroexpand のデフォルトは recursive=true, legacyscope=true | E-01 | ○ |
| C-07 | macroexpand! のデフォルトは legacyscope=false | E-02 | ○ |
| C-08 | 2引数版 @macroexpand は Julia 1.11 で追加 | E-01 | ○ |
| C-09 | @macroexpand のモジュール指定版は esc(mod) を使用 | E-03 | ○ |
| C-10 | docstring 内の例で M.f() の動作が示されている | E-01 | ○ |
| C-11 | jl_macroexpand は再帰的にマクロを展開する | **根拠なし** | △ |
| C-12 | ハイジーン処理でマクロ内変数にスコープ情報を付与 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-11, C-12: jl_macroexpand の内部実装は C ランタイム（src/ast.c）にあり、再帰展開やハイジーン処理の詳細は Julia ソースからは直接確認困難。
  - 候補：src/ast.c / src/macroexpand.scm

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - C ランタイム層の実装詳細は未確認
- 0: 低リスク - Julia 側の API インタフェースは正確に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] macroexpand と macroexpand! のデフォルト引数が正確か
- [ ] @macroexpand と macroexpand のモジュール解決の違いが正確か
- [ ] recursive=true/false の動作説明が正確か
- [ ] legacyscope パラメータの説明が正確か
