---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：6-整数演算

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **C-18**: checked.jlの存在と内容の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `base/int.jl` 10-24行目（型タプル定義）
- E-02: `base/int.jl` 26-40行目（Union型エイリアス）
- E-03: `base/int.jl` 83行目（比較演算子）
- E-04: `base/int.jl` 85-88行目（加減乗演算子）
- E-05: `base/int.jl` 94-97行目（整数除算→float変換）
- E-06: `base/int.jl` 177-194行目（signbit, flipsign, copysign）
- E-07: `base/int.jl` 227-228行目（abs関数）
- E-08: `base/int.jl` 230行目（ビット反転）
- E-09: `base/int.jl` 255-267行目（unsigned/signed変換）
- E-10: `base/int.jl` 341-344行目（div/rem定義）
- E-11: `base/intfuncs.jl` 44-51行目（gcd関数）
- E-12: `base/intfuncs.jl` 80-95行目（_gcd バイナリアルゴリズム）
- E-13: `base/int.jl` 117-135行目（mul_hi関数）
- E-14: `base/int.jl` 138-155行目（isodd/iseven関数）
- E-15: `機能一覧.csv` 6行目（機能説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BitSigned/BitUnsigned/BitIntegerの型グループが定義されている | E-01, E-02 | ○ |
| C-02 | 符号付き比較がslt_intで実装 | E-03 | ○ |
| C-03 | 加算がadd_int、減算がsub_int、乗算がmul_intで実装 | E-04 | ○ |
| C-04 | 整数除算（/）はfloat変換される | E-05 | ○ |
| C-05 | signbit, flipsign, copysignが定義されている | E-06 | ○ |
| C-06 | absがflipsign(x,x)で実装 | E-07 | ○ |
| C-07 | ビット反転が~(n) = -n-1で実装 | E-08 | ○ |
| C-08 | unsigned/signed変換関数が定義されている | E-09 | ○ |
| C-09 | div/remがchecked_sdiv_int/checked_udiv_intで実装 | E-10 | ○ |
| C-10 | gcd関数がユークリッドの互除法で実装 | E-11 | ○ |
| C-11 | _gcd関数がSteinのバイナリアルゴリズムで実装 | E-12 | ○ |
| C-12 | mul_hi関数が上位ビットの積を計算 | E-13 | ○ |
| C-13 | isodd/iseven関数が定義されている | E-14 | ○ |
| C-14 | デフォルト整数演算はオーバーフロー時にラップアラウンド | E-04 | ○ |
| C-15 | ゼロ除算はDivideErrorを投げる | E-10 | ○ |
| C-16 | 定義はbase/int.jlとbase/intfuncs.jlで行われる | E-15 | ○ |
| C-17 | 32ビットマシン互換のBitSignedSmall_types等がある | E-01 | ○ |
| C-18 | checked.jlにオーバーフロー検出付き演算がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: base/checked.jlの存在と内容を直接確認していない
  - 候補：base/checked.jl / base/int.jl内のchecked_xxx関数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本演算の記述はint.jlソースコードと高い整合性
- 0: 低リスク - gcd/lcm等の数論関数の記述はintfuncs.jlと一致
- 0: 低リスク - 型グループ定義の記述は正確

## 6) レビュアーチェックリスト（最小）
- [ ] int.jlの行番号が最新ソースと一致しているか確認
- [ ] checked.jlの存在と内容を確認
- [ ] 整数除算のfloat変換に関する記述が正確か確認
