---
generated_at: 2026-02-04 11:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：60-パッケージ読み込み

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **プリコンパイルキャッシュのロード詳細**: _require_search_from_serialized の内部実装確認が必要
  2. **compilecache の詳細フロー**: プリコンパイルプロセスの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `base/loading.jl` 3085-3138行目（include_string 関数）
- E-02: `base/loading.jl` 3180-3198行目（_include 関数）
- E-03: `base/loading.jl` 3225-3234行目（evalfile 関数）
- E-04: `base/loading.jl` 2556-2562行目（require 関数）
- E-05: `base/loading.jl` 2576-2626行目（__require 関数）
- E-06: `base/loading.jl` 2687-2705行目（_require_prelocked 関数）
- E-07: `base/loading.jl` 2813-2949行目（__require_prelocked 関数）
- E-08: `base/loading.jl` 356-430行目（identify_package_env 関数）
- E-09: `base/loading.jl` 477-556行目（locate_package_env / locate_package 関数）
- E-10: `base/loading.jl` 2404-2424行目（start_loading / end_loading 関数）
- E-11: `base/loading.jl` 2440-2470行目（_include_dependency 関数）
- E-12: `base/loading.jl` 2715-2717行目（loaded_modules / loaded_precompiles / loaded_modules_order）
- E-13: `base/loading.jl` 2707-2712行目（PkgOrigin 構造体）
- E-14: `base/loading.jl` 2736-2758行目（register_root_module 関数）
- E-15: `base/loading.jl` 1-82行目（isfile_casesensitive 関数 OS 別実装）
- E-16: `base/pkgid.jl` 3-9行目（PkgId 構造体）
- E-17: `base/initdefs.jl` 141-194行目（LOAD_PATH 定義）
- E-18: `base/loading.jl` 2525-2554行目（TRACE_EVAL グローバル変数）
- E-19: `docs/code-to-docs/機能一覧/機能一覧.csv` 60行目
- E-20: `base/loading.jl` 2764-2771行目（__toplevel__ baremodule）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | include_string は Meta.parseall でパース後、各式を Core.eval で評価 | E-01 | ○ |
| C-02 | include_string でエラー時は LoadError でラップ | E-01 | ○ |
| C-03 | _include は _include_dependency でパス解決後、read でファイル読み込み、include_string で評価 | E-02 | ○ |
| C-04 | _include は task_local_storage に SOURCE_PATH を設定 | E-02 | ○ |
| C-05 | evalfile は匿名モジュール Module(:__anon__) 内で include を実行 | E-03 | ○ |
| C-06 | evalfile は ARGS, include, eval を匿名モジュールに定義 | E-03 | ○ |
| C-07 | require はワールドエイジを取得し __require を invoke_in_world で呼び出す | E-04 | ○ |
| C-08 | __require は identify_package_env でパッケージを識別 | E-05 | ○ |
| C-09 | パッケージ未発見時にヒント付きの ArgumentError を生成 | E-05 | ○ |
| C-10 | _require_prelocked は start_loading で並行ロードの排他制御を行う | E-06, E-10 | ○ |
| C-11 | __require_prelocked はプリコンパイルキャッシュからのロードを最初に試行 | E-07 | ○ |
| C-12 | キャッシュ失敗時に compilecache でプリコンパイルを実行 | E-07 | ○ |
| C-13 | 最終フォールバックとして include(__toplevel__, path) でソースロード | E-07 | ○ |
| C-14 | loaded_modules は Dict{PkgId, Module} のグローバルレジストリ | E-12 | ○ |
| C-15 | isfile_casesensitive は OS 別に異なる実装を持つ | E-15 | ○ |
| C-16 | PkgId は UUID と名前のペアでパッケージを識別 | E-16 | ○ |
| C-17 | LOAD_PATH のデフォルトは ["@", "@v#.#", "@stdlib"] | E-17 | ○ |
| C-18 | TRACE_EVAL で include_string の評価トレースが可能 | E-18, E-01 | ○ |
| C-19 | プリコンパイルキャッシュは .ji ファイルとして保存される | **根拠不足** | △ |
| C-20 | パッケージイメージ（.so / .dylib）による高速化が可能 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-19: `.ji` ファイルの形式・保存場所の詳細は `base/loading.jl` の serialize/deserialize 関連コード（本レビューでは未読の部分）に記載。
  - 候補：`base/loading.jl` の `_require_search_from_serialized` / `_tryrequire_from_serialized` 関数
- C-20: パッケージイメージの詳細は `base/loading.jl` の `ocachefile_from_cachefile` 関数および JLOptions の `use_pkgimages` フラグに関連。
  - 候補：`base/loading.jl` の pkgimage 関連コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - include / include_string / evalfile の Julia 実装は正確に確認済み
- 0: 低リスク - require / __require / _require_prelocked の主要フローは確認済み
- 1: 中リスク - プリコンパイルキャッシュのロード/生成の詳細実装は部分的な確認のみ

## 6) レビュアーチェックリスト（最小）
- [ ] include_string の parseall → Core.eval ループが正確か
- [ ] _include の SOURCE_PATH 管理が正確か
- [ ] require のパッケージ識別フロー（identify_package_env）が正確か
- [ ] _require_prelocked の排他制御（start_loading / end_loading）が正確か
- [ ] __require_prelocked のプリコンパイルキャッシュ → compilecache → include フォールバックが正確か
- [ ] LOAD_PATH のデフォルト値と展開ロジックが正確か
