---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：61-プリコンパイル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **compilecache の詳細実装**：loading.jl 内の compilecache 関数は直接読み込んでいない
  2. **AOTコンパイルとの連携詳細**：src/aotcompile.cpp の内容は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/precompilation.jl` 1-27行目（ExplicitEnv 構造体定義）
- E-02: `base/precompilation.jl` 42-266行目（ExplicitEnv コンストラクタ）
- E-03: `base/precompilation.jl` 271-283行目（MiniProgressBar 構造体）
- E-04: `base/precompilation.jl` 285-286行目（プログレスバー定数）
- E-05: `base/precompilation.jl` 362-366行目（PkgPrecompileError）
- E-06: `base/precompilation.jl` 428-460行目（scan_deps!/scan_pkg! 循環依存検出）
- E-07: `base/precompilation.jl` 474-561行目（precompilepkgs 関数定義・ドキュメント）
- E-08: `base/precompilation.jl` 578-649行目（_precompilepkgs 実装）
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` 62行目
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ExplicitEnv は Project.toml / Manifest.toml を解析する | E-01, E-02 | ○ |
| C-02 | 循環依存を scan_deps! で検出する | E-06 | ○ |
| C-03 | 並列度は CPU_THREADS + 1（最大16）で Windows は半分 | E-08 (615-618行目) | ○ |
| C-04 | JULIA_NUM_PRECOMPILE_TASKS で制御可能 | E-08 (618行目) | ○ |
| C-05 | PkgPrecompileError 例外型が存在する | E-05 | ○ |
| C-06 | MiniProgressBar でプログレスバーを表示する | E-03, E-04 | ○ |
| C-07 | プログレスバーは30FPSに制限される | E-04 (285行目) | ○ |
| C-08 | precompilepkgs が公開APIエントリーポイント | E-07 | ○ |
| C-09 | _precompilepkgs が内部実装 | E-08 | ○ |
| C-10 | ExplicitEnv のフィールドは Project.toml セクションに対応 | E-01 | ○ |
| C-11 | 拡張はトリガーが環境に存在する場合のみプリコンパイル | E-07 (542行目) | ○ |
| C-12 | __precompile__(false) のパッケージはスキップ | E-07 (538-539行目) | ○ |
| C-13 | Semaphore で並列度を制御 | E-08 (619行目) | ○ |
| C-14 | configs パラメータで複数コンパイル設定を指定可能 | E-07 (512-514行目) | ○ |
| C-15 | キャッシュファイルはアトミックに書き込まれる | **根拠なし** | △ |
| C-16 | compilecache で個別パッケージのキャッシュ生成 | **根拠なし** | △ |
| C-17 | manifest=true でマニフェスト全体をプリコンパイル | E-07 (523-526行目) | ○ |
| C-18 | timing=true で各パッケージのコンパイル時間を表示 | E-07 (501-503行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-15: キャッシュファイルのアトミック書き込みについて、`base/loading.jl` の `compilecache` 実装を直接確認していない
  - 候補：`base/loading.jl` / `src/staticdata.c`
- C-16: `compilecache` 関数の実装詳細は `base/loading.jl` にあるが未読み込み
  - 候補：`base/loading.jl`

## 5) リスクフラグ（レビュー観点）
- 0: ExplicitEnv の構造体定義とフィールド説明は正確
- 0: 循環依存検出アルゴリズムの説明は正確
- 1: compilecache の詳細実装は未確認のため、キャッシュ生成の具体的な処理フローに不正確さがある可能性

## 6) レビュアーチェックリスト（最小）
- [ ] ExplicitEnv のフィールドと Project.toml/Manifest.toml の対応が正しいか
- [ ] 並列度の計算ロジックがソースコードと一致するか
- [ ] compilecache（loading.jl）の処理フローが設計書と整合するか
- [ ] AOTコンパイル関連ファイル（src/aotcompile.cpp, src/staticdata.c）の役割が正しいか
