---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：62-例外機構

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **Cランタイムのスタック巻き戻し詳細**：src/task.c の実装は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `base/error.jl` 19-26行目（throw のドキュメント）
- E-02: `base/error.jl` 60-74行目（rethrow の実装）
- E-03: `base/error.jl` 76-80行目（InterpreterIP 構造体）
- E-04: `base/error.jl` 84-114行目（_reformat_bt 関数）
- E-05: `base/error.jl` 117-128行目（backtrace 関数）
- E-06: `base/error.jl` 130-138行目（catch_backtrace 関数）
- E-07: `base/error.jl` 140-142行目（ExceptionStack 構造体）
- E-08: `base/error.jl` 144-172行目（current_exceptions 関数）
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` 63行目
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | throw は例外オブジェクトを送出する | E-01 | ○ |
| C-02 | rethrow() は ccall(:jl_rethrow) に委譲する | E-02 (73行目) | ○ |
| C-03 | rethrow(e) は ccall(:jl_rethrow_other) に委譲する | E-02 (74行目) | ○ |
| C-04 | InterpreterIP は code, stmt, mod フィールドを持つ | E-03 | ○ |
| C-05 | ExceptionStack は NamedTuple の配列を保持する | E-07 | ○ |
| C-06 | backtrace() は jl_backtrace_from_here を呼ぶ | E-05 (126行目) | ○ |
| C-07 | catch_backtrace() は jl_get_backtrace を呼ぶ | E-06 (136行目) | ○ |
| C-08 | current_exceptions は jl_get_excstack を呼ぶ | E-08 (163行目) | ○ |
| C-09 | _reformat_bt でネイティブ/インタプリタフレームを統合する | E-04 | ○ |
| C-10 | backtrace() は skip=1 で自身のフレームをスキップする | E-05 (125行目) | ○ |
| C-11 | current_exceptions は Julia 1.7 で名前が変更された | E-08 (158-160行目) | ○ |
| C-12 | finally ブロックは例外の有無に関係なく実行される | E-09（機能説明） | ○ |
| C-13 | 例外が発生しないパスではゼロコスト | E-09（言語仕様として） | ○ |
| C-14 | src/task.c に jl_throw の実装がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: `src/task.c` の内容は直接確認していない。jl_throw / jl_rethrow / jl_eh_restore の実装詳細が未確認
  - 候補：`src/task.c` / `src/julia.h`

## 5) リスクフラグ（レビュー観点）
- 0: Julia レベルの例外処理API（throw, rethrow, backtrace 等）は正確
- 1: C ランタイムレベルの実装詳細（スタック巻き戻しの具体的なメカニズム）は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] rethrow() の ccall 呼び出しがソースと一致するか
- [ ] current_exceptions の返り値形式が正しいか
- [ ] src/task.c の jl_throw 実装が設計書の記述と整合するか
