---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：63-例外型

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **boot.jl の Core 例外型定義**：boot.jl の具体的な行番号は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `base/error.jl` 33-57行目（error 関数）
- E-02: `base/error.jl` 181-188行目（systemerror 関数）
- E-03: `base/error.jl` 191-194行目（WindowsErrorInfo 構造体）
- E-04: `base/error.jl` 195-203行目（windowserror 関数）
- E-05: `base/error.jl` 209-246行目（@assert マクロ）
- E-06: `base/error.jl` 248-251行目（_assert_tostring）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` 64行目
- E-08: `base/errorshow.jl` 160-175行目（各種 showerror 定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | error(msg) は ErrorException(msg) を throw する | E-01 (47-57行目) | ○ |
| C-02 | error 関数は文字列引数以外も受け取れる | E-01 (47行目 Vararg) | ○ |
| C-03 | systemerror は errno ベースの SystemError を構築する | E-02 | ○ |
| C-04 | WindowsErrorInfo は errnum と extrainfo を持つ | E-03 | ○ |
| C-05 | windowserror は GetLastError ベースで動作する | E-04 | ○ |
| C-06 | @assert は条件が false なら AssertionError を throw する | E-05 (245行目) | ○ |
| C-07 | @assert は最適化レベルで無効化される可能性がある | E-05 (217-220行目 docstring) | ○ |
| C-08 | 基本例外型は Core (boot.jl) で定義される | **根拠なし** | △ |
| C-09 | error 関数の返り値型は Union{} に推論される | E-01 (30-32行目 コメント) | ○ |
| C-10 | systemerror は条件付き呼び出し形式がある | E-02 (187行目) | ○ |
| C-11 | ユーザーは struct MyError <: Exception で独自例外を定義可能 | E-08 (showerror docstring 例) | ○ |
| C-12 | _assert_tostring はブートストラップ中のフォールバックを持つ | E-06 (250-251行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-08: `base/boot.jl` を直接読み込んでいないため、Core 例外型の定義行番号が不明
  - 候補：`base/boot.jl`

## 5) リスクフラグ（レビュー観点）
- 0: error / systemerror / @assert の実装は正確に記述されている
- 1: boot.jl の Core 例外型定義の詳細（各型のフィールド構成）は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] boot.jl の Exception 型階層が設計書と一致するか
- [ ] 各例外型のフィールド定義が正確か
- [ ] error 関数の Union{} 返り値型推論の記述が正確か
