---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：64-エラー表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **show_backtrace の詳細実装**：errorshow.jl の後半部分は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `base/errorshow.jl` 1-30行目（showerror 基本定義）
- E-02: `base/errorshow.jl` 55-76行目（BoundsError 表示）
- E-03: `base/errorshow.jl` 78-105行目（TypeError 表示）
- E-04: `base/errorshow.jl` 107-113行目（showerror with backtrace）
- E-05: `base/errorshow.jl` 129-143行目（DomainError 表示）
- E-06: `base/errorshow.jl` 145-158行目（SystemError 表示）
- E-07: `base/errorshow.jl` 160-175行目（簡易エラー表示一覧）
- E-08: `base/errorshow.jl` 258-349行目（MethodError 表示）
- E-09: `base/stacktraces.jl` 51-78行目（StackFrame 構造体）
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | showerror(io, ex) のデフォルトは show(io, ex) | E-01 (30行目) | ○ |
| C-02 | showerror(io, ex, bt) は try/finally で実装される | E-04 (107-113行目) | ○ |
| C-03 | BoundsError は対象オブジェクトとインデックスを表示する | E-02 | ○ |
| C-04 | TypeError は期待型と実際型を表示する | E-03 | ○ |
| C-05 | MethodError は候補メソッドを検索して提示する | E-08 | ○ |
| C-06 | MethodError は他モジュールの同名関数を提案する | E-08 (334-349行目) | ○ |
| C-07 | DomainError は AbstractArray の場合にコンパクト表示する | E-05 (130-131行目) | ○ |
| C-08 | SystemError は errno のメッセージを表示する | E-06 | ○ |
| C-09 | StackFrame は func, file, line, linfo 等を持つ | E-09 | ○ |
| C-10 | StackTrace は Vector{StackFrame} のエイリアス | E-09 (78行目) | ○ |
| C-11 | Experimental.show_error_hints でエラーヒントを表示 | E-02 (75行目), E-03 (104行目) | ○ |
| C-12 | convert の MethodError では特別な表示が行われる | E-08 (291-293行目) | ○ |
| C-13 | show_backtrace の詳細実装が errorshow.jl にある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13: `show_backtrace` 関数の実装は errorshow.jl の後半部分にあると推定されるが、読み込み範囲外のため未確認
  - 候補：`base/errorshow.jl` 後半部分

## 5) リスクフラグ（レビュー観点）
- 0: 各例外型の showerror 実装は正確に記述されている
- 0: StackFrame の構造体定義は正確
- 1: show_backtrace の詳細（Cフレームのフィルタリング等）は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] MethodError の表示ロジックが網羅的に記述されているか
- [ ] show_backtrace の Cフレームフィルタリングの記述が正確か
- [ ] register_error_hint の使用方法が正確か
