---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：66-ccall

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **ccall_macro_lower の実装詳細**：c.jl の後半で定義されるが読み込み範囲外
  2. **src/ccall.cpp の LLVM コード生成詳細**：C++ファイルは未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `base/c.jl` 5行目（cglobal のインポート）
- E-02: `base/c.jl` 7-17行目（cglobal ドキュメント）
- E-03: `base/c.jl` 29-36行目（CFunction 構造体）
- E-04: `base/c.jl` 38-79行目（@cfunction マクロ）
- E-05: `base/c.jl` 81-136行目（プラットフォーム依存C型定義）
- E-06: `base/c.jl` 145-204行目（sigatomic / disable_sigint / reenable_sigint / exit_on_sigint）
- E-07: `base/c.jl` 245-262行目（@ccallable マクロ）
- E-08: `base/c.jl` 265-349行目（ccall_macro_parse）
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` 67行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CFunction は ptr, f, _1, _2 フィールドを持つ GC ハンドル | E-03 | ○ |
| C-02 | @cfunction の引数型はリテラルタプルでなければならない | E-04 (65-67行目) | ○ |
| C-03 | $ 接頭辞で動的 cfunction を生成する | E-04 (70-73行目) | ○ |
| C-04 | ccall_macro_parse は関数名・戻り値型・引数型・引数を返す | E-08 (265-276行目) | ○ |
| C-05 | @ccall の全引数に型アノテーションが必要 | E-08 (344-346行目) | ○ |
| C-06 | @ccall で gc_safe オプションが使用可能 | E-08 (278, 286-297行目) | ○ |
| C-07 | varargs は parameters で区切られる | E-08 (334-337行目) | ○ |
| C-08 | disable_sigint / reenable_sigint でシグナル制御 | E-06 | ○ |
| C-09 | @ccallable で C から呼び出し可能な関数を公開 | E-07 | ○ |
| C-10 | cglobal で C グローバル変数のポインタを取得 | E-01, E-02 | ○ |
| C-11 | exit_on_sigint で SIGINT の動作を制御 | E-06 (188-204行目) | ○ |
| C-12 | expand_ccallable が @ccallable のマクロ展開を行う | E-07 (210-243行目) | ○ |
| C-13 | _ccallable が jl_extern_c を呼び出す | E-06 (206-208行目) | ○ |
| C-14 | ccall_macro_lower が ccall 式への lowering を行う | **根拠なし** | △ |
| C-15 | src/ccall.cpp が LLVM IR 生成を行う | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: `ccall_macro_lower` 関数は c.jl の349行目以降にあると推定されるが読み込み範囲外
  - 候補：`base/c.jl` 349行目以降
- C-15: `src/ccall.cpp` は未読み込み
  - 候補：`src/ccall.cpp`

## 5) リスクフラグ（レビュー観点）
- 0: @cfunction / @ccallable のマクロ展開は正確
- 0: ccall_macro_parse の構文解析ロジックは正確
- 1: ccall の LLVM レベルの挙動は推測を含む
- 1: ccall_macro_lower の詳細は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] ccall_macro_lower の実装が設計書と整合するか
- [ ] src/ccall.cpp の LLVM コード生成が設計書の記述と一致するか
- [ ] gc_safe オプションの詳細動作が正確か
