---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：71-プロセス制御

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **setcpuaffinity の外部仕様詳細**：cmd.jl内の実装は確認済みだが、libuv側の挙動詳細は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `base/process.jl` 3-21行目 - Process構造体定義
- E-02: `base/process.jl` 27-35行目 - ProcessChain構造体定義
- E-03: `base/process.jl` 634-645行目 - kill関数定義
- E-04: `base/process.jl` 657-667行目 - getpid関数定義
- E-05: `base/process.jl` 676-687行目 - process_running/process_exited定義
- E-06: `base/process.jl` 63-79行目 - uv_return_spawnコールバック
- E-07: `base/process.jl` 49-60行目 - uvfinalize関数
- E-08: `base/process.jl` 698-720行目 - wait関数
- E-09: `base/process.jl` 558-565行目 - test_success関数
- E-10: `base/process.jl` 608-624行目 - pipeline_error関数
- E-11: `base/process.jl` 551-556行目 - シグナル定数定義
- E-12: `base/cmd.jl` 13-40行目 - Cmd構造体定義
- E-13: `base/process.jl` 90-97行目 - as_cpumask関数
- E-14: `base/process.jl` 591-594行目 - ProcessFailedException定義
- E-15: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 29行目 - シェルモードとの関連
- E-16: `docs/code-to-docs/機能一覧/機能一覧.csv` 72行目 - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Process構造体はhandle, exitcode, termsignal, exitnotifyを持つ | E-01 | ○ |
| C-02 | ProcessChainはVector{Process}を持つ | E-02 | ○ |
| C-03 | killのデフォルトシグナルはSIGTERM(15) | E-03, E-11 | ○ |
| C-04 | kill内でuv_process_killをccallで呼び出す | E-03 | ○ |
| C-05 | getpidはjl_uv_process_pidをccallで呼び出す | E-04 | ○ |
| C-06 | process_runningはhandle != C_NULLで判定 | E-05 | ○ |
| C-07 | uv_return_spawnでexitcode/termsignalが設定される | E-06 | ○ |
| C-08 | uvfinalizeでlibuvハンドルが解放される | E-07 | ○ |
| C-09 | waitはThreadSynchronizer(exitnotify)で待機する | E-08 | ○ |
| C-10 | test_successはexitcode==0 && termsignal==0で判定 | E-09 | ○ |
| C-11 | pipeline_errorはignorestatusフラグを確認する | E-10 | ○ |
| C-12 | as_cpumaskはVector{UInt16}をBool配列に変換する | E-13 | ○ |
| C-13 | ProcessFailedExceptionが定義されている | E-14 | ○ |
| C-14 | シェルモードからプロセス制御が利用される | E-15 | ○ |
| C-15 | Cmd構造体にdetach, env, uid, gidフラグがある | E-12 | ○ |
| C-16 | killでUV_ESRCHは正常終了として扱われる | E-03 | ○ |
| C-17 | iolock内でkillとgetpidが実行される | E-03, E-04 | ○ |
| C-18 | setcpuaffinityはlibuvのプロセスオプションとして渡される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- setcpuaffinityのlibuv側での挙動の詳細ドキュメント
  - 候補：libuv公式ドキュメント / Juliaのsrc/jl_uv.c / deps/libuv/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なプロセス制御APIの記述はソースコードと整合
- 1: 中リスク - setcpuaffinityのプラットフォーム依存動作の詳細は追加確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] kill関数のエラーハンドリングが正確に記述されているか確認
- [ ] Windows環境でのシグナル制限が正しく記載されているか確認
- [ ] setuid/setgidのセキュリティリスクの記述が十分か確認
