---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：73-型リフレクション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **typeintersectの内部実装**: Cランタイム側の実装詳細は未確認
  2. **Core組み込み関数の具体的なC実装マッピング**: boot.jlでの宣言は確認済みだが、src/側との対応詳細は部分的

## 2) 参照した情報（Evidence一覧）

- E-01: `base/reflection.jl` - 型リフレクション関数群の定義
- E-02: `base/boot.jl` - DataType/TypeName等の基盤型定義
- E-03: `base/essentials.jl` - 基本型操作
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 24行目 - ヘルプモード関連
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` 74行目 - 機能一覧定義
- E-06: `base/reflection.jl` 972-984行目 - which関数定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | typeofは具象型を返す | E-02 | ○ |
| C-02 | isaはCore組み込み関数 | E-02 | ○ |
| C-03 | supertypeはDataType.superフィールドを参照 | E-02 | ○ |
| C-04 | fieldnamesはTypeName.namesを参照 | E-02 | ○ |
| C-05 | fieldtypesはDataType.typesを参照 | E-02 | ○ |
| C-06 | isconcretetypeはccallで実装 | E-01 | ○ |
| C-07 | subtypesはjl_subtypesをccallで呼び出す | E-01 | ○ |
| C-08 | ヘルプモードで型リフレクションが利用される | E-04 | ○ |
| C-09 | reflection.jlに高レベルリフレクションAPIがある | E-01 | ○ |
| C-10 | supertypesは再帰的にsupertypeを呼び出す | E-01 | ○ |
| C-11 | isabstracttype(Union{A,B})はfalse | E-02 | ○ |
| C-12 | 型リフレクションの結果はコンパイラの型推論でも活用される | E-01, E-06 | ○ |
| C-13 | fieldoffsetはメモリオフセットを返す | E-01 | ○ |
| C-14 | nfieldsはフィールド数を返す | E-03 | ○ |
| C-15 | typeintersectは2つの型の交差型を計算する | **根拠なし** | △ |
| C-16 | Core組み込み関数はsrc/jltypes.cに実装されている | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- typeintersectのCランタイム側実装の詳細確認
  - 候補：src/jltypes.c / src/subtype.c
- Core組み込み関数とCランタイムの対応マッピング
  - 候補：src/builtins.c / src/jltypes.c

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な型リフレクションAPIの記述はソースコードと整合
- 1: 中リスク - Cランタイム側の詳細はソースコードの直接確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Core組み込み関数のリストが網羅的か確認
- [ ] DataTypeの主要フィールドの記述が正確か確認
- [ ] 型リフレクション関数のパフォーマンス特性の記述が妥当か確認
