---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：74-メソッドリフレクション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **functionlocの詳細実装**：reflection.jlには定義が確認できるが、ソース位置の取得メカニズムの詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `base/reflection.jl` 972-984行目 - which(f, t)
- E-02: `base/reflection.jl` 992-994行目 - which(tt)
- E-03: `base/reflection.jl` 1002-1007行目 - which(m, s)
- E-04: `base/reflection.jl` 1095-1121行目 - hasmethod
- E-05: `base/reflection.jl` 19-52行目 - code_lowered
- E-06: `base/reflection.jl` 355-387行目 - code_typed_by_type
- E-07: `base/reflection.jl` 270-284行目 - code_typed
- E-08: `base/reflection.jl` 304-317行目 - invoke_default_compiler
- E-09: `base/reflection.jl` 592-599行目 - return_types
- E-10: `base/reflection.jl` 493-517行目 - code_ircode_by_type
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 25行目
- E-12: `docs/code-to-docs/機能一覧/機能一覧.csv` 75行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | which(f,t)はsignature_typeでタプル型を構築する | E-01 | ○ |
| C-02 | which(f,t)は_findsupで最適メソッドを検索する | E-01 | ○ |
| C-03 | which(m,s)はbinding_moduleでモジュールを特定する | E-03 | ○ |
| C-04 | hasmethod(f,t)はCore._hasmethodを呼ぶ | E-04 | ○ |
| C-05 | hasmethod(f,t,kwnames)はkwnamesのサブセット判定を行う | E-04 | ○ |
| C-06 | kwargs...を持つメソッドは全kwnames検証をパスする | E-04 | ○ |
| C-07 | code_loweredはuncompressed_irを使用する | E-05 | ○ |
| C-08 | code_typed_by_typeはtypeinf_codeを呼び出す | E-06 | ○ |
| C-09 | code_typed_by_typeはNativeInterpreterを構築する | E-06 | ○ |
| C-10 | generated functionsからcode reflectionは使用不可 | E-06 | ○ |
| C-11 | REFLECTION_COMPILERでコンパイラモジュールを切り替え可能 | E-08 | ○ |
| C-12 | invoke_in_typeinf_worldで型推論ワールドの関数を呼び出す | E-08 | ○ |
| C-13 | return_typesは推論される戻り値型のリストを返す | E-09 | ○ |
| C-14 | code_ircode_by_typeはoptimize_untilパラメータをサポートする | E-10 | ○ |
| C-15 | ヘルプモードでmethods/whichが利用される | E-11 | ○ |
| C-16 | debuginfoは:sourceと:noneをサポートする | E-05, E-06 | ○ |
| C-17 | functionlocはメソッドのソースコード位置を返す | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- functionlocの実装詳細（ソース位置取得のメカニズム）
  - 候補：base/reflection.jl内の別の箇所 / base/methodshow.jl

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なメソッドリフレクションAPIの記述はソースコードと整合
- 0: 低リスク - コンパイラとの連携部分も根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] which関数の全オーバーロードが網羅されているか確認
- [ ] code_typed系関数のキーワード引数が正確に記載されているか確認
- [ ] ワールドエイジ制約の記述が正確か確認
