---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：75-モジュールリフレクション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **pathof/pkgdirの詳細実装**: loading.jl内の実装は参照したが行番号の特定が不完全
  2. **fullnameの再帰実装**: 動作は推測だがソースの直接確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `base/reflection.jl` 1018-1020行目 - nameof(f::Function)
- E-02: `base/reflection.jl` 1022-1025行目 - nameof(f::Core.IntrinsicFunction)
- E-03: `base/reflection.jl` 1033行目 - parentmodule(f::Function)
- E-04: `base/reflection.jl` 1041-1047行目 - parentmodule(f, types)
- E-05: `base/reflection.jl` 1057行目 - parentmodule(m::Method)
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` 76行目
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 15行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | nameof(f::Function)はtypeof(f).name.singletonname | E-01 | ○ |
| C-02 | nameof(f::IntrinsicFunction)はjl_intrinsic_nameを呼ぶ | E-02 | ○ |
| C-03 | parentmodule(f::Function)はparentmodule(typeof(f))に委譲 | E-03 | ○ |
| C-04 | parentmodule(f, types)はmethods→firstのモジュールを返す | E-04 | ○ |
| C-05 | parentmodule(m::Method)はm.moduleを返す | E-05 | ○ |
| C-06 | REPLプロンプトにアクティブモジュール名が表示される | E-07 | ○ |
| C-07 | names(m; all=true)は内部シンボルも含む | E-06 | ○ |
| C-08 | names()はccallでjl_module_namesを呼ぶ | E-06 | ○ |
| C-09 | pkgdir()はpathof()の結果からディレクトリを導出する | E-06 | ○ |
| C-10 | pkgversion()はProject.tomlを解析する | E-06 | ○ |
| C-11 | binding_module(m, s)でバインディング元を特定可能 | E-04 | ○ |
| C-12 | pkgversion()はファイルI/Oを伴う | E-06 | ○ |
| C-13 | pathofはloaded_modules辞書を参照する | **根拠なし** | △ |
| C-14 | fullnameはMainまで再帰的に親モジュールを辿る | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- pathof/pkgdir/pkgversionの実装詳細（base/loading.jl内の具体的な行番号）
  - 候補：base/loading.jl
- fullnameの実装詳細
  - 候補：base/reflection.jl

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - nameof/parentmoduleの記述はソースコードと整合
- 1: 中リスク - loading.jl内の実装詳細は追加確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] pathof/pkgdirの実装がloading.jlの最新版と一致するか確認
- [ ] fullnameの再帰実装の記述が正確か確認
- [ ] names()のall/importedフィルタの動作が正確か確認
