---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：76-計時

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 全ての主張に根拠が確認されている

## 2) 参照した情報（Evidence一覧）

- E-01: `base/timing.jl` 4-75行目 - GC_Num構造体
- E-02: `base/timing.jl` 80-90行目 - GC_Diff構造体
- E-03: `base/timing.jl` 95-108行目 - GC_Diff コンストラクタ
- E-04: `base/timing.jl` 110-112行目 - gc_alloc_count
- E-05: `base/timing.jl` 393-406行目 - @timeマクロ
- E-06: `base/timing.jl` 466-479行目 - @timevマクロ
- E-07: `base/timing.jl` 499-506行目 - @elapsedマクロ
- E-08: `base/timing.jl` 620-622行目 - @allocatedマクロ
- E-09: `base/timing.jl` 641-643行目 - @allocationsマクロ
- E-10: `base/timing.jl` 670-681行目 - @lock_conflictsマクロ
- E-11: `base/timing.jl` 730-758行目 - @timedマクロ
- E-12: `base/timing.jl` 252-303行目 - time_print
- E-13: `base/timing.jl` 305-322行目 - timev_print
- E-14: `base/timing.jl` 241-250行目 - format_bytes
- E-15: `base/timing.jl` 554-590行目 - _gen_allocation_measurer
- E-16: `base/timing.jl` 114-128行目 - cumulative_compile_time_ns/cumulative_compile_timing
- E-17: `base/timing.jl` 423-427行目 - @showtimeマクロ
- E-18: `base/timing.jl` 92-93行目 - gc_total_bytes

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GC_NumはGCカウンタの全フィールドを保持する構造体 | E-01 | ○ |
| C-02 | GC_Diffはnew-oldで差分を計算する | E-02, E-03 | ○ |
| C-03 | gc_alloc_count = malloc + realloc + poolalloc + bigalloc | E-04 | ○ |
| C-04 | @timeは@timedの結果をtime_printでstdoutに出力 | E-05 | ○ |
| C-05 | @timevは詳細カウンタを表示する | E-06 | ○ |
| C-06 | @elapsedはtime_ns()の差分を返す | E-07 | ○ |
| C-07 | @allocatedはバイト単位のアロケーション量を返す | E-08 | ○ |
| C-08 | @allocationsはアロケーション回数を返す | E-09 | ○ |
| C-09 | @lock_conflictsはLOCK_CONFLICT_COUNTの差分を返す | E-10 | ○ |
| C-10 | @timedはNamedTupleを返す | E-11 | ○ |
| C-11 | @timedは@__tryfinallyで計測終了処理を保証する | E-11 | ○ |
| C-12 | time_printはRyu.writefixedで浮動小数点フォーマットする | E-12 | ○ |
| C-13 | format_bytesはKiB/MiB/GiB単位へ変換する | E-14 | ○ |
| C-14 | _gen_allocation_measurerは関数呼び出し形式を最適化する | E-15 | ○ |
| C-15 | cumulative_compile_time_nsでコンパイル時間を取得する | E-16 | ○ |
| C-16 | @showtimeは式の文字列表現付きで計時する | E-17 | ○ |
| C-17 | gc_total_bytes = allocd + deferred_alloc + total_allocd | E-18 | ○ |
| C-18 | GC_NumはC構造体gc-interface.hと同期されている | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠が確認されている

## 6) レビュアーチェックリスト（最小）
- [ ] GC_Numのフィールド記述がsrc/gc-interface.hのC構造体と一致するか確認
- [ ] @timedのNamedTupleフィールドが最新バージョンと一致するか確認
- [ ] @allocated/@allocationsの最適化ロジックの記述が正確か確認
