---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：77-GC制御

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 全ての主張にソースコード根拠が確認されている

## 2) 参照した情報（Evidence一覧）

- E-01: `base/gcutils.jl` 110-112行目 - GCモジュール定義、public宣言
- E-02: `base/gcutils.jl` 115-117行目 - GC_AUTO/GC_FULL/GC_INCREMENTAL定数
- E-03: `base/gcutils.jl` 133-134行目 - GC.gc()
- E-04: `base/gcutils.jl` 146行目 - GC.enable()
- E-05: `base/gcutils.jl` 234-240行目 - GC.@preserve
- E-06: `base/gcutils.jl` 264行目 - GC.safepoint()
- E-07: `base/gcutils.jl` 84-88行目 - finalizer(f, o)
- E-08: `base/gcutils.jl` 90-95行目 - finalizer(Ptr, o)
- E-09: `base/gcutils.jl` 102-103行目 - finalize()
- E-10: `base/gcutils.jl` 39-43行目 - _check_mutable
- E-11: `base/gcutils.jl` 156-167行目 - enable_finalizers/disable_finalizers
- E-12: `base/gcutils.jl` 182-184行目 - in_finalizer()
- E-13: `base/gcutils.jl` 271-273行目 - enable_logging
- E-14: `base/gcutils.jl` 280-282行目 - logging_enabled
- E-15: `base/gcutils.jl` 290-292行目 - gc_active_impl
- E-16: `base/gcutils.jl` 1-32行目 - WeakRef

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GCモジュールはbase/gcutils.jl内にネストモジュールとして定義 | E-01 | ○ |
| C-02 | GC_AUTO=0, GC_FULL=1, GC_INCREMENTAL=2 | E-02 | ○ |
| C-03 | GC.gcはjl_gc_collectをccallで呼ぶ | E-03 | ○ |
| C-04 | GC.enableはjl_gc_enableをccallで呼び前の状態を返す | E-04 | ○ |
| C-05 | @preserveはExpr(:gc_preserve, ...)を生成する | E-05 | ○ |
| C-06 | @preserveの引数はSymbolでなければならない | E-05 | ○ |
| C-07 | GC.safepointはjl_gc_safepointをccallで呼ぶ | E-06 | ○ |
| C-08 | finalizerは_check_mutableで検証後Core.finalizerを呼ぶ | E-07, E-10 | ○ |
| C-09 | 非mutable型にfinalizerを登録するとErrorException | E-10 | ○ |
| C-10 | Cポインタfinalizer版はjl_gc_add_ptr_finalizerを使用 | E-08 | ○ |
| C-11 | finalizeはjl_finalize_thで即時実行 | E-09 | ○ |
| C-12 | enable_finalizersはカウンタベースの制御 | E-11 | ○ |
| C-13 | in_finalizerはjl_gc_is_in_finalizerで判定 | E-12 | ○ |
| C-14 | enable_loggingはjl_enable_gc_loggingを呼ぶ | E-13 | ○ |
| C-15 | gc_active_implはjl_gc_active_implで実装名を取得 | E-15 | ○ |
| C-16 | WeakRefは弱参照を提供する | E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠が確認されている

## 6) レビュアーチェックリスト（最小）
- [ ] GCモードの定数値がCランタイム側と一致するか確認
- [ ] ファイナライザの制約事項（タスクスイッチ禁止等）の記述が十分か確認
- [ ] @preserveのセマンティクスがコンパイラの実装と一致するか確認
