---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：78-性能アノテーション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **@pollyの実際の効果**: Pollyポリヘドラル最適化パスの有効性は限定的で、実験的機能

## 2) 参照した情報（Evidence一覧）

- E-01: `base/boot.jl` 329-330行目 - @inline/@noinline基本定義
- E-02: `base/essentials.jl` 119-128行目 - @nospecialize
- E-03: `base/essentials.jl` 899-901行目 - @boundscheck
- E-04: `base/essentials.jl` 931-937行目 - @inbounds
- E-05: `base/expr.jl` 383-385行目 - @inline(x)
- E-06: `base/expr.jl` 460-462行目 - @noinline(x)
- E-07: `base/expr.jl` 499-518行目 - @constprop
- E-08: `base/expr.jl` 1086-1088行目 - @polly
- E-09: `base/simdloop.jl` 127-137行目 - @simd
- E-10: `base/essentials.jl` 130-145行目 - @specialize
- E-11: `docs/code-to-docs/機能一覧/機能一覧.csv` 79行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @inlineはExpr(:meta, :inline)を生成する | E-01 | ○ |
| C-02 | @noinlineはExpr(:meta, :noinline)を生成する | E-01 | ○ |
| C-03 | @nospecializeはExpr(:meta, :nospecialize, vars...)を生成 | E-02 | ○ |
| C-04 | @boundscheckはExpr(:if, Expr(:boundscheck), blk)を生成 | E-03 | ○ |
| C-05 | @inboundsはExpr(:inbounds, true)とExpr(:inbounds, :pop)で式をラップ | E-04 | ○ |
| C-06 | @inline(x)はannotate_meta_def_or_blockを呼び出す | E-05 | ○ |
| C-07 | @constpropは:aggressive→:aggressive_constpropに変換 | E-07 | ○ |
| C-08 | @constpropは:none→:no_constpropに変換 | E-07 | ○ |
| C-09 | @pollyはpushmeta!(ex, :polly)を呼び出す | E-08 | ○ |
| C-10 | @simd(forloop)はcompile(forloop, nothing)を呼び出す | E-09 | ○ |
| C-11 | @simd ivdepはcompile(forloop, Symbol("julia.ivdep"))を呼び出す | E-09 | ○ |
| C-12 | コールサイトアノテーションが定義アノテーションに優先 | E-05 | ○ |
| C-13 | @boundscheck関数はインライン化されないと@inboundsが効かない | E-03 | ○ |
| C-14 | @nospecializeはコード生成のみに影響し型推論には影響しない | E-02 | ○ |
| C-15 | @simdは最内ループ、直線コード等の要件がある | E-09 | ○ |
| C-16 | @pollyはポリヘドラル最適化を適用する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- @pollyの実効性とLLVM Pollyパスとの具体的な連携詳細
  - 候補：src/codegen.cpp / LLVM Pollyドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なアノテーションマクロの記述はソースコードと整合
- 2: 高リスク - @inboundsの不正使用によるメモリ安全性のリスクは十分に記述する必要がある

## 6) レビュアーチェックリスト（最小）
- [ ] @inboundsのセキュリティリスクの記述が十分か確認
- [ ] @inline/@noinlineのコールサイトとの優先順位の記述が正確か確認
- [ ] @simdの要件（直線コード、ユニットストライド等）の記述が正確か確認
