---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：83-型推論ユーティリティ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **抽象解釈エンジンからの呼び出しパス**：abstractinterpretation.jl の呼び出し箇所を確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `Compiler/src/tfuncs.jl` - @nospecs マクロ（23-50行目）
- E-02: `Compiler/src/tfuncs.jl` - テーブル定数（52-58行目）
- E-03: `Compiler/src/tfuncs.jl` - find_tfunc 関数（60-66行目）
- E-04: `Compiler/src/tfuncs.jl` - add_tfunc（IntrinsicFunction）（79-83行目）
- E-05: `Compiler/src/tfuncs.jl` - add_tfunc（Builtin）（84-88行目）
- E-06: `Compiler/src/tfuncs.jl` - throw の tfunc（90行目）
- E-07: `Compiler/src/tfuncs.jl` - instanceof_tfunc（98行目〜）
- E-08: `Compiler/src/tfuncs.jl` - DATATYPE_TYPES_FIELDINDEX 等（68-69行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | T_IFUNC は IntrinsicFunction の型推論テーブル | E-02 | ○ |
| C-02 | T_FFUNC_KEY/VAL は Builtin の型推論テーブル | E-02 | ○ |
| C-03 | @nospecs マクロが引数に @nospecialize を自動付与 | E-01 | ○ |
| C-04 | IntrinsicFunction の add_tfunc はインデックス直接アクセス | E-04 | ○ |
| C-05 | Builtin の add_tfunc はリスト末尾追加 | E-05 | ○ |
| C-06 | find_tfunc は T_FFUNC_KEY を線形検索 | E-03 | ○ |
| C-07 | throw の tfunc は常に Bottom を返す | E-06 | ○ |
| C-08 | instanceof_tfunc は typeof の逆演算 | E-07 | ○ |
| C-09 | N_IFUNC = reinterpret(Int32, have_fma) + 1 | E-02 | ○ |
| C-10 | INT_INF = typemax(Int) | E-02 | ○ |
| C-11 | IntrinsicFunction のテーブル検索は O(1) | E-04 | ○ |
| C-12 | Builtin のテーブル検索は O(n)（線形） | E-03 | ○ |
| C-13 | DATATYPE_TYPES_FIELDINDEX / DATATYPE_NAME_FIELDINDEX が定義 | E-08 | ○ |
| C-14 | 抽象解釈エンジンが abstract_call_builtin で tfunc を呼び出す | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- abstractinterpretation.jl の abstract_call_builtin 関数を確認していない
  - 候補：`Compiler/src/abstractinterpretation.jl` の abstract_call_builtin

## 5) リスクフラグ（レビュー観点）
- 0: tfuncs.jl のテーブル構造と関数定義は全て直接確認済み、低リスク
- 1: 呼び出し元の abstractinterpretation.jl は未確認、中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] T_IFUNC / T_FFUNC テーブルの構造が正しいか
- [ ] @nospecs マクロの展開結果が正しいか
- [ ] 抽象解釈からの呼び出しパス（C-14）の確認
