---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：87-GCランタイム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **マークフェーズの詳細フロー**：gc_mark_roots の呼び出し元を確認していない
  2. **GCヒューリスティクスの計算式**：次回collect_intervalの計算ロジックを確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `src/gc-interface.h` - jl_gc_num_t 構造体（28-80行目）
- E-02: `src/gc-stock.c` - gc_heap_stats / max_total_memory（18-30行目）
- E-03: `src/gc-stock.c` - default_collect_interval（33-36行目）
- E-04: `src/gc-stock.c` - GCスレッド関連変数（39-67行目）
- E-05: `src/gc-stock.c` - GC同期コメント（81-100行目）
- E-06: `src/gc-stock.c` - jl_gc_small_alloc（780行目）
- E-07: `src/gc-stock.c` - jl_gc_big_alloc（468行目）
- E-08: `src/gc-stock.c` - gc_sweep_pool / gc_sweep_page（863, 1363行目）
- E-09: `src/gc-stock.c` - gc_mark_finlist（2178行目）
- E-10: `src/gc-stock.c` - jl_gc_queue_root（1494行目）
- E-11: `src/gc-stock.c` - support_conservative_marking（79行目）
- E-12: `src/gc-mmtk.c` - MMTk バインディング（1-60行目）
- E-13: `src/gc-common.c` - GC コールバック（29-78行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | jl_gc_num_t に allocd, freed, total_time 等のフィールドがある | E-01 | ○ |
| C-02 | デフォルトの collect_interval は ~45MiB（64bit） | E-03 | ○ |
| C-03 | max_total_memory のデフォルトは 2PiB（64bit） | E-02 | ○ |
| C-04 | jl_n_markthreads / jl_n_sweepthreads で並列スレッド数を設定 | E-04 | ○ |
| C-05 | GC同期で jl_safepoint_start_gc / jl_gc_wait_for_the_world を使用 | E-05 | ○ |
| C-06 | jl_gc_small_alloc がプールからの小オブジェクト割当 | E-06 | ○ |
| C-07 | jl_gc_big_alloc が大オブジェクトの割当 | E-07 | ○ |
| C-08 | gc_sweep_pool / gc_sweep_page で並列プールスイープ | E-08 | ○ |
| C-09 | gc_mark_finlist でファイナライザリストをマーク | E-09 | ○ |
| C-10 | jl_gc_queue_root がライトバリアを実装 | E-10 | ○ |
| C-11 | support_conservative_marking で保守的マーキングをサポート | E-11 | ○ |
| C-12 | MMTk 対応の GC バインディングが存在 | E-12 | ○ |
| C-13 | GC コールバック（pre_gc, post_gc 等）が登録可能 | E-13 | ○ |
| C-14 | gc_heap_stats がグローバルヒープ統計を保持 | E-02 | ○ |
| C-15 | jl_full_sweep_reasons で理由別カウンタを記録 | E-04 | ○ |
| C-16 | GC_MAX_SZCLASS が 2032 バイト | E-01 | ○ |
| C-17 | マークフェーズの詳細な開始・終了フロー | **根拠なし** | △ |
| C-18 | GCヒューリスティクスによる次回interval計算 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- gc-stock.c のマークフェーズ全体のオーケストレーション（_jl_gc_collect 内部）を確認していない
  - 候補：`src/gc-stock.c` の _jl_gc_collect 関数
- GCヒューリスティクスの計算ロジックを確認していない
  - 候補：`src/gc-stock.c` のヒューリスティクス更新コード

## 5) リスクフラグ（レビュー観点）
- 0: データ構造・変数定義は全て直接確認済み、低リスク
- 0: 個別の割当・スイープ・マーク関数は行番号で確認済み、低リスク
- 1: 全体のGCサイクルフローとヒューリスティクスは推定部分あり、中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] jl_gc_num_t のフィールドが正しいか
- [ ] GC同期メカニズムの記述が正しいか
- [ ] マークフェーズの詳細フロー（C-17）を確認
- [ ] GCヒューリスティクスの計算（C-18）を確認
