---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 13
  claims_without_evidence: 3
confidence_derived: 0.81
---

# 根拠レポート：89-型システムランタイム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.81**
  - 根拠あり：13 / 16、根拠なし：3
- 優先レビュー（高）
  1. **jl_apply_generic のディスパッチフロー**：gf.c の後半を確認していない
  2. **型キャッシュの実装詳細**：jltypes.c の型キャッシュ操作を確認していない
  3. **メソッド無効化の処理**：gf.c のbackedge/invalidation を確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `src/jltypes.c` - 冒頭コメント・グローバル変数（1-30行目）
- E-02: `src/jltypes.c` - max_probe / h2index マクロ（33-34行目）
- E-03: `src/jltypes.c` - typeenv_has / typeenv_has_ne（38-56行目）
- E-04: `src/jltypes.c` - layout_uses_free_typevars（59-80行目）
- E-05: `src/gf.c` - 冒頭コメント（1-10行目）
- E-06: `src/gf.c` - jl_world_counter / allow_new_worlds（27-28行目）
- E-07: `src/gf.c` - jl_get_world_counter（31-37行目）
- E-08: `src/gf.c` - get_max_varargs（50-80行目）
- E-09: `src/gf.c` - MAX_UNSPECIALIZED_CONFLICTS（21行目）
- E-10: `src/subtype.c` - 冒頭コメント（1-21行目）
- E-11: `src/subtype.c` - jl_bits_stack_t / jl_unionstate_t（43-60行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | jltypes.c が型の構築・キャッシュを実装 | E-01 | ○ |
| C-02 | max_probe マクロで型キャッシュの検索を制限 | E-02 | ○ |
| C-03 | typeenv_has で型環境の変数検索 | E-03 | ○ |
| C-04 | layout_uses_free_typevars で自由型変数チェック | E-04 | ○ |
| C-05 | gf.c がジェネリック関数・メソッドテーブル・ディスパッチを実装 | E-05 | ○ |
| C-06 | jl_world_counter がアトミックな世代カウンタ | E-06 | ○ |
| C-07 | pure_callback 中は ~(size_t)0 を返す | E-07 | ○ |
| C-08 | get_max_varargs が max_varargs の計算ヒューリスティクスを提供 | E-08 | ○ |
| C-09 | MAX_UNSPECIALIZED_CONFLICTS = 32 | E-09 | ○ |
| C-10 | サブタイプアルゴリズムが Jeff Bezanson の博士論文に基づく | E-10 | ○ |
| C-11 | 対角線ルールの実装 | E-10 | ○ |
| C-12 | jl_bits_stack_t が Union コンポーネント選択を追跡 | E-11 | ○ |
| C-13 | jl_unionstate_t が Union 状態を追跡 | E-11 | ○ |
| C-14 | jl_apply_generic がメソッドディスパッチのエントリーポイント | **根拠なし** | △ |
| C-15 | 型キャッシュがハッシュテーブルで実装されている | **根拠なし** | △ |
| C-16 | メソッド定義のバックエッジ無効化処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- gf.c の jl_apply_generic 関数を確認していない
  - 候補：`src/gf.c` の jl_apply_generic
- jltypes.c の型キャッシュ操作（挿入・検索）の実装を確認していない
  - 候補：`src/jltypes.c` の型キャッシュ関数群
- gf.c のメソッド無効化処理を確認していない
  - 候補：`src/gf.c` のバックエッジ処理コード

## 5) リスクフラグ（レビュー観点）
- 0: 型環境操作・サブタイプアルゴリズムの概要は確認済み、低リスク
- 0: ワールドカウンタ・Varargs 処理は直接確認済み、低リスク
- 1: ディスパッチフロー・型キャッシュ・無効化は推定部分あり、中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] サブタイプアルゴリズムの記述が正しいか
- [ ] ワールドカウンタのセマンティクスが正しいか
- [ ] jl_apply_generic のディスパッチフロー（C-14）を確認
- [ ] 型キャッシュの実装（C-15）を確認
- [ ] メソッド無効化処理（C-16）を確認
