---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：90-メモリ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **配列リサイズ・動的拡張の処理**：push!/append! に対応するC実装を確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `src/array.c` - MAXINTVAL 定数（19行目）
- E-02: `src/array.c` - jl_array_validate_dims（21-33行目）
- E-03: `src/array.c` - jl_array_elsize マクロ（51行目）
- E-04: `src/array.c` - jl_array_typetagdata（53-57行目）
- E-05: `src/array.c` - _new_array（59-73行目）
- E-06: `src/array.c` - new_array（75-80行目）
- E-07: `src/genericmemory.c` - jl_genericmemory_typetagdata（20-25行目）
- E-08: `src/genericmemory.c` - jl_alloc_genericmemory_unchecked（30-53行目）
- E-09: `src/genericmemory.c` - _new_genericmemory_（55-73行目）
- E-10: `src/genericmemory.c` - jl_alloc_genericmemory（75-80行目）
- E-11: `src/gc-common.c` - gc_num / GCコールバック（18-78行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MAXINTVAL = (((size_t)-1)>>1) | E-01 | ○ |
| C-02 | jl_array_validate_dims が __builtin_mul_overflow でチェック | E-02 | ○ |
| C-03 | nel == 0 の場合はシングルトンインスタンスを返却 | E-09 | ○ |
| C-04 | プール/malloc 閾値は GC_MAX_SZCLASS | E-08 | ○ |
| C-05 | Union メモリで追加のタグバイトが加算される | E-09 | ○ |
| C-06 | jl_alloc_genericmemory_unchecked はコード生成器専用 | E-08 | ○ |
| C-07 | プール割当のメモリは JL_SMALL_BYTE_ALIGNMENT でアライン | E-08 | ○ |
| C-08 | 非プールの場合は jl_gc_managed_malloc で確保 | E-08 | ○ |
| C-09 | jl_gc_track_malloced_genericmemory で GC 追跡登録 | E-08 | ○ |
| C-10 | _new_array が jl_gc_alloc でヘッダを割当 | E-05 | ○ |
| C-11 | Array ヘッダサイズ = sizeof(jl_array_t) + ndims*sizeof(size_t) | E-05 | ○ |
| C-12 | ref.mem に GenericMemory、ref.ptr_or_offset にポインタ/オフセット | E-05 | ○ |
| C-13 | Union/ゼロサイズ要素の場合は ptr_or_offset = 0 | E-05 | ○ |
| C-14 | ゼロ初期化は memset で実行 | E-09 | ○ |
| C-15 | __builtin_add_overflow でタグバイト加算のオーバーフローチェック | E-09 | ○ |
| C-16 | push!/append! に対応する配列リサイズ処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- array.c の配列リサイズ関連関数（jl_array_grow_*, jl_array_del_*）を確認していない
  - 候補：`src/array.c` の配列拡張・縮小関数

## 5) リスクフラグ（レビュー観点）
- 0: array.c / genericmemory.c の割当関数は行番号レベルで確認済み、低リスク
- 0: オーバーフローチェック・プール/malloc 分岐は直接確認済み、低リスク
- 1: 配列リサイズ処理は未確認、中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] jl_array_validate_dims のオーバーフロー検出が正しいか
- [ ] プール/malloc の閾値判定が正しいか
- [ ] Union メモリのタグバイトレイアウトが正しいか
- [ ] 配列リサイズ処理（C-16）を確認
