---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：91-タスクスケジューラ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **DEFAULT_THREAD_SLEEP_THRESHOLDの具体値**：ヘッダでの定義を未確認
  2. **partr.jlとのJulia側インターフェース詳細**：Julia側コードの詳細解析が不足

## 2) 参照した情報（Evidence一覧）
- E-01: `src/scheduler.c` - スケジューラ実装の中核ファイル（全578行）
- E-02: `src/task.c` - タスク管理実装
- E-03: `src/safepoint.c` - セーフポイント機構（jl_safepoint_take_sleep_lock）
- E-04: `src/julia_internal.h` - 内部宣言
- E-05: `src/threading.h` - スレッド関連定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sleep_check_stateは0(not_sleeping), 1(sleeping), 2(dead)の3状態 | E-01 (22-29行目) | ○ |
| C-02 | n_threads_runningはアトミック変数で実行中スレッド数を管理 | E-01 (34行目) | ○ |
| C-03 | jl_task_get_nextが中核のスケジューリングループ | E-01 (365行目) | ○ |
| C-04 | get_next_taskでjl_apply_genericを呼びJulia側関数を呼出 | E-01 (306-316行目) | ○ |
| C-05 | sleep_check_after_thresholdでjl_hrtimeを使い閾値判定 | E-01 (166-187行目) | ○ |
| C-06 | rr環境下では即座にスリープ許可 | E-01 (175-176行目) | ○ |
| C-07 | wake_threadでCASによりsleep状態を遷移しuv_cond_signal | E-01 (216-233行目) | ○ |
| C-08 | wakeup_threadで自スレッドの場合uv_stopを呼出 | E-01 (260-261行目) | ○ |
| C-09 | スレッド0のみがthreadedregion外でI/Oイベントループを処理 | E-01 (432行目) | ○ |
| C-10 | scheduler_delete_threadでsleeping_like_the_deadに遷移 | E-01 (556行目) | ○ |
| C-11 | jl_init_threadinginfraで環境変数からsleep_thresholdを設定 | E-01 (85-96行目) | ○ |
| C-12 | jl_init_thread_schedulerでsleep_lockとwake_signalを初期化 | E-01 (127-138行目) | ○ |
| C-13 | JULIA_DEBUG_SLEEPWAKEマクロでデバッグ用サイクルカウンタ記録 | E-01 (57-62行目, 456-458行目) | ○ |
| C-14 | DTraceプローブが各状態遷移に埋め込まれている | E-01 (JL_PROBE_RT_SLEEP_CHECK_*) | ○ |
| C-15 | JL_CATCHブロックでn_threads_runningを復元しrethrow | E-01 (537-543行目) | ○ |
| C-16 | 最後の実行スレッドがスリープ時にスレッド0を通知 | E-01 (490-501行目) | ○ |
| C-17 | jl_cpu_pause()でビジーウェイト中のCPU資源節約 | E-01 (376, 382行目) | ○ |
| C-18 | jl_safepoint_take_sleep_lockでGC_SAFEに遷移しスリープロック取得 | E-03 (301-318行目) | ○ |
| C-19 | DEFAULT_THREAD_SLEEP_THRESHOLDの具体的な値 | **根拠なし** | △ |
| C-20 | partr.jlがJulia側スケジューラインターフェース | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- DEFAULT_THREAD_SLEEP_THRESHOLDの定義はthreading.hまたはjulia_internal.hに存在する可能性が高いが、今回の読解範囲では具体値を確認できなかった
  - 候補：`src/threading.h` / `src/julia_internal.h` / `src/support/dtypes.h`
- partr.jlの詳細な実装解析が不足している
  - 候補：`base/partr.jl` / `base/task.jl`

## 5) リスクフラグ（レビュー観点）
- 0: scheduler.cの中核ロジック（jl_task_get_next）は直接ソースコードから確認済み
- 0: アトミック操作とメモリフェンスのパターンはソースコード中のコメントと一致
- 1: Julia側（partr.jl）との連携詳細は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] sleep_check_stateの3状態遷移が正しく記述されているか確認
- [ ] jl_task_get_nextのフローチャートがソースコードのロジックと一致するか確認
- [ ] DEFAULT_THREAD_SLEEP_THRESHOLDの具体値を確認し補完
- [ ] partr.jlの実装を確認しJulia側インターフェースの記述を補完
