---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：92-シグナル処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **signals-mach.cの詳細**：macOS固有実装の詳細解析が不足

## 2) 参照した情報（Evidence一覧）
- E-01: `src/signals-unix.c` - Unix系シグナル処理の中核実装（全1572行）
- E-02: `src/safepoint.c` - セーフポイント機構
- E-03: `src/stackwalk.c` - バックトレース取得
- E-04: `src/julia_internal.h` - 内部宣言

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | segv_handlerがSIGSEGV/SIGBUSを処理 | E-01 (514-568行目) | ○ |
| C-02 | セーフポイントアドレスへのアクセスでGC待機 | E-01 (527行目) | ○ |
| C-03 | スタック上アドレスでStackOverflowError | E-01 (549-551行目) | ○ |
| C-04 | 書き込みフォルトでReadOnlyMemoryError | E-01 (562-563行目) | ○ |
| C-05 | usr2_handlerでsignal_requestに基づき4種の処理 | E-01 (708-766行目) | ○ |
| C-06 | signal_listenerでsigwait/keventで待機 | E-01 (1043-1237行目) | ○ |
| C-07 | jl_try_deliver_sigintでスレッド0にSIGINT配信 | E-01 (658-669行目) | ○ |
| C-08 | eventfdによるスレッド同期プロトコル | E-01 (576-654行目) | ○ |
| C-09 | sig_stack_size = 8MB | E-01 (45行目) | ○ |
| C-10 | jl_install_default_signal_handlersで全ハンドラ登録 | E-01 (1311-1387行目) | ○ |
| C-11 | restore_signalsでシグナルリスナースレッド起動 | E-01 (1239-1261行目) | ○ |
| C-12 | メモリバリア実装は3種から選択 | E-01 (1488-1570行目) | ○ |
| C-13 | timer_graceperiod_elapsedで2秒猶予期間 | E-01 (773-776行目) | ○ |
| C-14 | スレッド0のみがSIGINT対象 | E-01 (530-531行目) | ○ |
| C-15 | thread0_exit_count > 1で段階的強制終了 | E-01 (1170-1173行目) | ○ |
| C-16 | is_write_faultがアーキテクチャ固有 | E-01 (396-505行目) | ○ |
| C-17 | jl_fake_signal_returnトランポリンでCFI維持 | E-01 (78-160行目) | ○ |
| C-18 | signals-mach.cのMach例外処理の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- signals-mach.cはsignals-unix.c内で`#include`されているが、今回の読解ではその詳細実装を確認していない
  - 候補：`src/signals-mach.c`

## 5) リスクフラグ（レビュー観点）
- 0: signals-unix.cの主要ハンドラはすべてソースコードから確認済み
- 1: macOS Mach例外ハンドラの詳細は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] segv_handlerの分岐条件がソースコードと一致するか確認
- [ ] usr2_handlerのsignal_requestプロトコルが正確か確認
- [ ] signals-mach.cの内容を確認しmacOS固有部分を補完
