---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：93-デバッグ情報

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **jl_getFunctionInfoの詳細実装**：debuginfo.cppの全行読解が不足
  2. **debuginfo.h/debug-registry.hの構造体定義**：ヘッダの詳細読解が不足

## 2) 参照した情報（Evidence一覧）
- E-01: `src/debuginfo.cpp` - デバッグ情報管理（先頭100行のみ読解）
- E-02: `src/stackwalk.c` - スタックウォーク実装（先頭80行のみ読解）
- E-03: `src/signals-unix.c` - rec_backtrace_ctxの呼び出し箇所

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JITDebugInfoRegistryがグローバルインスタンスとして存在 | E-01 (47行目) | ○ |
| C-02 | mangle関数でLLVM Manglerを使用 | E-01 (85-93行目) | ○ |
| C-03 | add_code_in_flightでコンパイル中コードを登録 | E-01 (95-97行目) | ○ |
| C-04 | lookupCodeInstanceでポインタからコードインスタンス検索 | E-01 (99行目) | ○ |
| C-05 | processFDEsでEHFrameを処理し__register_frameを呼出 | E-01 (63-83行目) | ○ |
| C-06 | is_enter_interpreter_frameでインタープリタフレーム検出 | E-02 (34-51行目) | ○ |
| C-07 | jl_unw_stepnでフレーム遍歴 | E-02 (72-79行目) | ○ |
| C-08 | Windows環境ではRtlCaptureContextを使用 | E-02 (17-20行目) | ○ |
| C-09 | jl_unw_getがsetjmpと同様にマクロ定義 | E-02 (14-25行目) | ○ |
| C-10 | nroots & 2でタグ付きフレームを検出 | E-02 (39行目) | ○ |
| C-11 | JL_DISABLE_LIBUNWINDでスタックウォーク無効化 | E-02 (23-24行目) | ○ |
| C-12 | DWARFContext経由でソース位置解決 | E-01 (6-7行目のinclude) | ○ |
| C-13 | シグナルハンドラ内でrec_backtrace_ctxが呼ばれる | E-03 (328-330行目) | ○ |
| C-14 | jl_getFunctionInfoの詳細な実装フロー | **根拠なし** | △ |
| C-15 | debuginfo.h/debug-registry.hのクラス構造 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- debuginfo.cppは先頭100行のみ読解したため、jl_getFunctionInfoの完全な実装が未確認
  - 候補：`src/debuginfo.cpp` (100行目以降)
- debuginfo.hおよびdebug-registry.hのクラス定義を読解していない
  - 候補：`src/debuginfo.h` / `src/debug-registry.h`

## 5) リスクフラグ（レビュー観点）
- 1: debuginfo.cppの後半（jl_getFunctionInfo実装）は推測を含む
- 0: stackwalk.cの基本構造はソースコードから確認済み
- 1: ヘッダファイルの詳細構造が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] debuginfo.cppの全体を確認しjl_getFunctionInfoの記述を検証
- [ ] debuginfo.hとdebug-registry.hの構造体定義を確認
- [ ] stackwalk.cのjl_unw_stepnの全体フローを確認
