---
generated_at: 2026-02-04 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：96-コマンドラインインタフェース

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張にソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
- E-01: `cli/loader_exe.c` - 実行ファイルエントリーポイント（全77行）
- E-02: `src/jloptions.c` - オプション解析（先頭207行）
- E-03: `cli/loader.h` - ローダーヘッダ定義
- E-04: `cli/loader_lib.c` - jl_load_repl実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | mainCRTStartupはWindows用エントリーポイント | E-01 (28行目) | ○ |
| C-02 | CommandLineToArgvでWindowsコマンドライン解析 | E-01 (31行目) | ○ |
| C-03 | wchar_to_utf8で引数変換 | E-01 (48行目) | ○ |
| C-04 | ASAN/TSANでLBT_USE_RTLD_DEEPBIND=0設定 | E-01 (42行目) | ○ |
| C-05 | jl_load_repl(argc, argv)呼び出し | E-01 (58行目) | ○ |
| C-06 | jl_init_optionsでデフォルト値設定 | E-02 (89-171行目) | ○ |
| C-07 | jl_options_initializedフラグで1回のみ実行 | E-02 (91-92行目) | ○ |
| C-08 | parse_heap_size_optionで単位付きサイズ解析 | E-02 (39-85行目) | ○ |
| C-09 | %指定時にuv_get_total_memory使用 | E-02 (68-73行目) | ○ |
| C-10 | ascii_tolowerでロケール非依存変換 | E-02 (24-29行目) | ○ |
| C-11 | system_image_pathは256バイト固定バッファ | E-02 (31行目) | ○ |
| C-12 | shlib_extがプラットフォーム固有 | E-02 (14-20行目) | ○ |
| C-13 | usage/opts文字列でヘルプメッセージ定義 | E-02 (173-207行目) | ○ |
| C-14 | jl_load_replでjl_repl_entrypoint検索・呼出 | E-04 (442-459行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] jl_options_tの主要フィールドとデフォルト値が正確か確認
- [ ] コマンドラインオプション一覧が最新か確認（opts文字列と照合）
