---
generated_at: 2026-02-04 11:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：97-動的ローダー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張にソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
- E-01: `cli/loader_lib.c` - 動的ローダー実装（全474行）
- E-02: `cli/loader.h` - ローダーヘッダ（全86行）
- E-03: `cli/loader_exe.c` - 実行ファイルエントリーポイント（全77行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | jl_load_libjulia_internalはconstructor属性 | E-01 (241行目) | ○ |
| C-02 | dep_libsは1024バイト固定バッファ | E-01 (24行目) | ○ |
| C-03 | jl_get_libdirでdladdr/GetModuleFileNameWを使用 | E-01 (156-209行目) | ○ |
| C-04 | スペシャルライブラリは3つ(libstdc++, internal, codegen) | E-01 (270行目) | ○ |
| C-05 | Linux:全シグナルブロックしてからロード | E-01 (248-250行目) | ○ |
| C-06 | libstdcxxprobeでシステムlibstdc++判定 | E-01 (229-236行目) | ○ |
| C-07 | JULIA_PROBE_LIBSTDCXX環境変数で制御可能 | E-01 (326-332行目) | ○ |
| C-08 | libjulia-codegenはオプション（err=0） | E-01 (365行目) | ○ |
| C-09 | codegen不在時にfallback関数名を使用 | E-01 (379-388行目) | ○ |
| C-10 | ランタイムシンボルループでlookup_symbolし再エクスポート | E-01 (391-398行目) | ○ |
| C-11 | jl_pgcstack_setkeyでFast TLS設定 | E-01 (413-426行目) | ○ |
| C-12 | jl_init_options_addrを呼出 | E-01 (401行目) | ○ |
| C-13 | jl_load_replでjl_repl_entrypointを検索 | E-01 (453行目) | ○ |
| C-14 | load_libraryでRTLD_NOLOADによる既ロードチェック | E-01 (59行目) | ○ |
| C-15 | WindowsではDllMainCRTStartupがconstructor代替 | E-01 (462-468行目) | ○ |
| C-16 | Linux:ロード後にシグナルマスク復元 | E-01 (437行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: loader_lib.cの全行を読解し、全主張を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] DEP_LIBSの実際の値（ビルド環境依存）を確認
- [ ] jl_exports.hのシンボル名テーブルとloader_lib.cの再エクスポートループが一致するか確認
