---
generated_at: 2026-02-04 11:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：98-Dates

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **エポック定義の正確な値**：types.jlの後半部分の詳細読解が不足

## 2) 参照した情報（Evidence一覧）
- E-01: `stdlib/Dates/src/Dates.jl` - モジュール定義（全88行）
- E-02: `stdlib/Dates/src/types.jl` - 型定義（先頭100行）
- E-03: Datesモジュールのdocstring

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AbstractTime→Period/Instant/TimeType型階層 | E-02 (3, 21, 89行目) | ○ |
| C-02 | DatePeriod: Year, Quarter, Month, Week, Day | E-02 (52-57行目) | ○ |
| C-03 | TimePeriod: Hour〜Nanosecond | E-02 (58-63行目) | ○ |
| C-04 | Period型はvalue::Int64の単一フィールド | E-02 (53-56行目) | ○ |
| C-05 | UTInstant{P}がInstantの具象型 | E-02 (98-99行目) | ○ |
| C-06 | ISO 8601準拠の先発グレゴリオ暦 | E-03 (docstring 10行目) | ○ |
| C-07 | UTベース86400秒/日 | E-03 (docstring 8行目) | ○ |
| C-08 | includeファイル順序 | E-01 (40-51行目) | ○ |
| C-09 | エクスポートシンボルリスト | E-01 (53-84行目) | ○ |
| C-10 | Base演算子のimport | E-01 (35行目) | ○ |
| C-11 | Printf使用 | E-01 (36行目) | ○ |
| C-12 | DatePeriod比較制限（Year(1)!=Day(365)） | E-02 (30-33行目 docstring) | ○ |
| C-13 | TimePeriod完全変換（Hour(1)==Minute(60)） | E-02 (48-50行目 docstring) | ○ |
| C-14 | @dateformat_strマクロがエクスポートされている | E-01 (83行目) | ○ |
| C-15 | エポック値（0000-12-31をratadie日0） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- types.jlの100行目以降にDate/DateTime/Timeの完全な定義があるが、読解していない
  - 候補：`stdlib/Dates/src/types.jl` (100行目以降)

## 5) リスクフラグ（レビュー観点）
- 0: モジュール構造とエクスポートはDates.jlから完全に確認済み
- 1: エポック定義の正確な値は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] types.jlのDate/DateTime/Time定義を確認
- [ ] エポック値の正確な定義を確認
- [ ] conversions.jlのnow()/today()実装を確認
