---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  1. **Pkgモードの詳細動作**：Pkg.jl本体は外部パッケージであり、ダミーモードからの切替ロジックのみ確認済み
  2. **履歴検索モードの起動キー**：Ctrl+Rのバインドは History モジュール内で実装されているが、バインド定義箇所の直接確認は限定的
  3. **TerminalMenusの呼び出し元**：コンポーネントとしての存在は確認済みだが、実際の利用箇所は標準ライブラリ外にも存在する可能性あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `stdlib/REPL/src/REPL.jl` - REPL モジュール本体（banner関数、各モード定義、プロンプト定数）
- E-02: `stdlib/REPL/src/LineEdit.jl` - 行編集・モード管理・PrefixHistoryPrompt定義
- E-03: `stdlib/REPL/src/docview.jl` - ヘルプモードのhelpmode()関数
- E-04: `stdlib/REPL/src/TerminalMenus/TerminalMenus.jl` - TerminalMenusモジュール定義
- E-05: `stdlib/REPL/src/TerminalMenus/RadioMenu.jl` - RadioMenu実装
- E-06: `stdlib/REPL/src/TerminalMenus/MultiSelectMenu.jl` - MultiSelectMenu実装
- E-07: `stdlib/REPL/src/TerminalMenus/Pager.jl` - Pager実装
- E-08: `stdlib/REPL/src/History/search.jl` - 履歴検索のrunsearch関数・イベントループ
- E-09: `stdlib/REPL/src/History/prompt.jl` - 履歴検索プロンプト・キーマップ定義
- E-10: `base/client.jl` - Julia起動処理・run_fallback_repl・run_std_repl関数
- E-11: `stdlib/REPL/src/options.jl` - REPLオプション定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 起動バナー画面が存在し、banner()関数で描画される | E-01（1735-1800行: banner関数定義） | ○ |
| C-02 | Juliaプロンプト（julia>）がデフォルトのREPLモードである | E-01（113行: JULIA_PROMPT定数, 1290行: julia_prompt設定） | ○ |
| C-03 | ヘルプモード（help?>）が「?」キーで遷移し、docviewで処理される | E-01（116行: HELP_PROMPT, 1304-1312行: help_mode定義, 1418-1428行: ?キーバインド）, E-03 | ○ |
| C-04 | シェルモード（shell>）が「;」キーで遷移し、Base.repl_cmdで処理される | E-01（115行: SHELL_PROMPT, 1316-1330行: shell_mode定義, 1406-1417行: ;キーバインド）, E-10 | ○ |
| C-05 | Pkgモード（pkg>）が「]」キーで遷移し、ダミーモードから本体へ切り替わる | E-01（114行: PKG_PROMPT, 1332-1359行: dummy_pkg_mode, 1430-1478行: ]キーバインド） | ○ |
| C-06 | 履歴検索モードがインクリメンタル検索を提供する | E-08（runsearch関数）, E-09（select_keymap, create_prompt） | ○ |
| C-07 | プレフィックス検索モードがPrefixHistoryPromptで実装される | E-02（2254-2415行: PrefixHistoryPrompt, PrefixSearchState定義） | ○ |
| C-08 | RadioMenuが単一選択メニューを提供する | E-05（RadioMenu struct定義, pick関数でselected設定） | ○ |
| C-09 | MultiSelectMenuが複数選択メニューを提供する | E-06（MultiSelectMenu struct, keypress関数でa/n/dキー処理） | ○ |
| C-10 | Pagerがページ単位スクロール表示を提供する | E-07（Pager struct, header関数でパーセンテージ表示） | ○ |
| C-11 | フォールバックREPLがREPL読込失敗時に使用される | E-10（442-482行: run_fallback_repl関数, 484-499行: run_std_repl内の分岐処理） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全ての主張がソースコードの直接確認により裏付けられている。
  - 補足：Pkgモードの完全な動作仕様はPkg.jl（外部パッケージ）に依存するため、ダミーモード部分のみの確認となっている
  - 補足：履歴検索モードのCtrl+Rバインドはsetup_interface内のキーマップで設定されるが、REPLHistoryProviderとの統合部分の詳細な起動フローは間接的な確認に留まる

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全画面がソースコード上で直接確認済み
- 1: 中リスク - Pkgモードは外部依存（Pkg.jl）があるため、ダミーモード以降の動作は本リポジトリのコードだけでは完全に把握できない
- 0: 低リスク - TerminalMenusコンポーネントは独立したモジュールとして明確に定義されている

## 6) レビュアーチェックリスト（最小）
- [ ] 各画面名とプロンプト文字列がソースコードの定数定義と一致しているか確認
- [ ] 画面遷移のトリガーキー（?、;、]、Ctrl+R等）がキーマップ定義と一致しているか確認
- [ ] TerminalMenusの3コンポーネント（RadioMenu, MultiSelectMenu, Pager）が全て網羅されているか確認
- [ ] フォールバックREPLへの遷移条件（ダム端末/REPL読込失敗）がclient.jlの実装と一致しているか確認
- [ ] 本リポジトリ外の画面（例：Pkg.jlが提供するPkgモードの詳細）が必要であれば追加検討
