# 画面遷移図

Julia REPL の画面（モード）間の遷移を示す。

## 全体遷移図

```mermaid
stateDiagram-v2
    [*] --> 起動バナー画面 : Juliaプロセス起動

    起動バナー画面 --> Juliaプロンプト : バナー表示後

    state "REPL モード" as repl_modes {
        Juliaプロンプト --> ヘルプモード : "?" キー入力\n（行頭で入力時）
        Juliaプロンプト --> シェルモード : ";" キー入力\n（行頭で入力時）
        Juliaプロンプト --> Pkgモード : "]" キー入力\n（行頭で入力時）
        Juliaプロンプト --> 履歴検索モード : Ctrl+R
        Juliaプロンプト --> プレフィックス検索 : 上下矢印キー\n（入力がある状態で）

        ヘルプモード --> Juliaプロンプト : Backspace（行頭で）\nまたは Ctrl+C
        シェルモード --> Juliaプロンプト : Backspace（行頭で）\nまたは Ctrl+C
        Pkgモード --> Juliaプロンプト : Backspace（行頭で）\nまたは Ctrl+C

        履歴検索モード --> Juliaプロンプト : 確定 / Ctrl+C / Ctrl+D
        履歴検索モード --> ヘルプモード : help履歴を選択して確定
        履歴検索モード --> シェルモード : shell履歴を選択して確定
        履歴検索モード --> Pkgモード : pkg履歴を選択して確定

        プレフィックス検索 --> Juliaプロンプト : 検索終了
    }

    Juliaプロンプト --> [*] : Ctrl+D（終了）

    state "TerminalMenus コンポーネント" as menus {
        RadioMenu : 単一選択メニュー\n矢印キーで移動\nEnterで確定
        MultiSelectMenu : 複数選択メニュー\nEnterでトグル\nd で確定
        Pager : ページャ\n上下キーでスクロール\nEnterで終了
    }

    note right of menus
        TerminalMenus はプログラムから
        request() で呼び出される
        独立したUIコンポーネント
    end note

    state "フォールバック" as fallback {
        フォールバックREPL : 簡易プロンプト\n（REPL読込失敗時）
    }

    起動バナー画面 --> フォールバックREPL : REPL読込失敗時\nまたはダム端末
    フォールバックREPL --> [*] : EOF / Ctrl+D
```

## 遷移キー一覧

| 遷移元 | 遷移先 | トリガー |
|--------|--------|----------|
| 起動バナー画面 | Juliaプロンプト | 自動（バナー表示完了後） |
| 起動バナー画面 | フォールバックREPL | REPL読込失敗 / ダム端末 |
| Juliaプロンプト | ヘルプモード | `?` キー（行頭） |
| Juliaプロンプト | シェルモード | `;` キー（行頭） |
| Juliaプロンプト | Pkgモード | `]` キー（行頭） |
| Juliaプロンプト | 履歴検索モード | `Ctrl+R` |
| Juliaプロンプト | プレフィックス検索 | 上下矢印キー（入力がある状態） |
| ヘルプモード | Juliaプロンプト | `Backspace`（行頭）/ `Ctrl+C` |
| シェルモード | Juliaプロンプト | `Backspace`（行頭）/ `Ctrl+C` |
| Pkgモード | Juliaプロンプト | `Backspace`（行頭）/ `Ctrl+C` |
| 履歴検索モード | Juliaプロンプト | 確定 / `Ctrl+C` / `Ctrl+D` |
| プレフィックス検索 | Juliaプロンプト | 検索終了 |
| Juliaプロンプト | 終了 | `Ctrl+D` |
| フォールバックREPL | 終了 | `EOF` / `Ctrl+D` |
