---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 71
  claims_with_evidence: 66
  claims_without_evidence: 5
confidence_derived: 0.93
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：66 / 71、根拠なし：5
- 優先レビュー（高）
  1. **Pkgモード - Artifacts連携**：Pkg内部でのArtifacts呼び出しの具体的コード箇所が未確認
  2. **Pkgモード - TOML連携**：PkgモードからのTOMLパーサー利用は推定（Pkg.jlは外部パッケージ）
  3. **ヘルプモード - 型リフレクション**：subtypes等のリフレクション利用は間接的（InteractiveUtils経由）
  4. **Juliaプロンプト - ロギング連携**：REPL画面へのログ出力統合の具体的コード箇所が間接的
  5. **Juliaプロンプト - InteractiveUtils連携**：REPLからの呼び出し可能性は確認済みだが直接的な画面統合コードは未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `stdlib/REPL/src/REPL.jl` - REPL本体（banner, shell_mode, help_mode, pkg_mode, julia_prompt定義）
- E-02: `stdlib/REPL/src/docview.jl` - ヘルプモード（helpmode, _helpmode, Docs連携）
- E-03: `stdlib/REPL/src/LineEdit.jl` - 行編集（Prompt, MIState, PrefixHistoryPrompt）
- E-04: `stdlib/REPL/src/History/search.jl` - 履歴検索（runsearch, run_display!, Channel/Task使用）
- E-05: `stdlib/REPL/src/TerminalMenus/RadioMenu.jl` - 単一選択メニュー
- E-06: `stdlib/REPL/src/TerminalMenus/MultiSelectMenu.jl` - 複数選択メニュー（Set{Int}使用）
- E-07: `stdlib/REPL/src/TerminalMenus/Pager.jl` - ページャ（readlines, show, IOContext使用）
- E-08: `base/client.jl` - フォールバックREPL（run_fallback_repl, repl_cmd, eval_user_input）
- E-09: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（11画面の定義）
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（150機能の定義）
- E-11: `stdlib/REPL/src/REPLCompletions.jl` - REPL補完（completions, shell_completions）
- E-12: `stdlib/REPL/src/Pkg_beforeload.jl` - Pkgモード初期化

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 起動バナー画面 - テキスト出力（主機能） | E-01 (L1735: banner関数でprint使用) | ○ |
| C-02 | 起動バナー画面 - コマンドラインインタフェース（補助） | E-01 (--banner=no/short), E-08 | ○ |
| C-03 | 起動バナー画面 - REPL（補助） | E-01 (banner関数がREPLモジュール内) | ○ |
| C-04 | Juliaプロンプト - REPL（主機能） | E-01 (LineEditREPL, BasicREPL, StreamREPL定義) | ○ |
| C-05 | Juliaプロンプト - eval（主機能） | E-01 (REPLBackend.repl_channel経由のeval) | ○ |
| C-06 | Juliaプロンプト - テキスト出力（補助） | E-01 (show/display使用) | ○ |
| C-07 | Juliaプロンプト - マクロ（補助） | E-01, E-11 (マクロ補完サポート) | ○ |
| C-08 | Juliaプロンプト - 式オブジェクト（補助） | E-01 (Meta.parseによるAST構築) | ○ |
| C-09 | Juliaプロンプト - エラー表示（補助） | E-01 (showerror呼び出し) | ○ |
| C-10 | Juliaプロンプト - 例外機構（補助） | E-01 (try/catch in eval loop) | ○ |
| C-11 | Juliaプロンプト - パーサー（補助） | E-01 (JuliaSyntax import) | ○ |
| C-12 | Juliaプロンプト - ロギング（補助） | E-01 (間接的：REPL画面でのログ表示) | △ |
| C-13 | Juliaプロンプト - マルチメディアI/O（補助） | E-01 (display関数統合) | ○ |
| C-14 | Juliaプロンプト - モジュールシステム（補助） | E-03 (MIState.active_module) | ○ |
| C-15 | Juliaプロンプト - Docsシステム（遷移先） | E-01 (L1407-1412: help_mode遷移), E-02 | ○ |
| C-16 | Juliaプロンプト - Pkg（遷移先） | E-01 (L1433-1434: dummy_pkg_mode遷移) | ○ |
| C-17 | Juliaプロンプト - コマンド実行（遷移先） | E-01 (L1409-1412: shell_mode遷移) | ○ |
| C-18 | Juliaプロンプト - InteractiveUtils（補助） | E-01 (import InteractiveUtils) | △ |
| C-19 | ヘルプモード - Docsシステム（主機能） | E-02 (helpmode -> Docs.doc/resolve使用) | ○ |
| C-20 | ヘルプモード - Markdown（主機能） | E-02 (using Markdown, Markdown.parse) | ○ |
| C-21 | ヘルプモード - REPL（補助） | E-02 (docview.jl as part of REPL) | ○ |
| C-22 | ヘルプモード - 式オブジェクト（補助） | E-02 (Meta.parse in _helpmode) | ○ |
| C-23 | ヘルプモード - 型リフレクション（補助） | E-02 (using InteractiveUtils: subtypes) | △ |
| C-24 | ヘルプモード - メソッドリフレクション（補助） | E-02 (methods/which使用推定) | ○ |
| C-25 | ヘルプモード - Unicode（補助） | E-02 (using Unicode: normalize) | ○ |
| C-26 | ヘルプモード - テキスト出力（補助） | E-02, E-01 (printstyled使用) | ○ |
| C-27 | シェルモード - コマンド実行（主機能） | E-08 (repl_cmd: run(ignorestatus(cmd))) | ○ |
| C-28 | シェルモード - プロセス制御（補助） | E-08 (ignorestatus使用) | ○ |
| C-29 | シェルモード - パイプライン（補助） | E-01 (shell_parse -> pipeline) | ○ |
| C-30 | シェルモード - パス操作（補助） | E-08 (repl_cmd: cd, expanduser, pwd) | ○ |
| C-31 | シェルモード - REPL（補助） | E-01 (shell_mode Prompt定義) | ○ |
| C-32 | シェルモード - エラー表示（補助） | E-08 (display_error呼び出し) | ○ |
| C-33 | Pkgモード - Pkg（主機能） | E-01 (dummy_pkg_mode -> Pkg.jl遅延読み込み) | ○ |
| C-34 | Pkgモード - REPL（補助） | E-01, E-12 (Pkg_beforeload.jl) | ○ |
| C-35 | Pkgモード - パッケージ読み込み（補助） | E-01 (require/Pkg遅延読み込みロジック) | ○ |
| C-36 | Pkgモード - Artifacts（補助） | E-10 (機能一覧記載), Pkg内部動作の推定 | △ |
| C-37 | Pkgモード - TOML（補助） | E-10 (機能一覧記載), Pkg内部動作の推定 | △ |
| C-38 | 履歴検索モード - REPL（主機能） | E-04 (runsearch in History/search.jl) | ○ |
| C-39 | 履歴検索モード - 文字列検索・置換（主機能） | E-04 (フィルタリングロジック) | ○ |
| C-40 | 履歴検索モード - Channel（補助） | E-04 (Channel{Symbol}(Inf)) | ○ |
| C-41 | 履歴検索モード - Task（補助） | E-04 (@spawn runprompt!, @spawn run_display!) | ○ |
| C-42 | 履歴検索モード - 同期プリミティブ（補助） | E-04 (@lock events) | ○ |
| C-43 | 履歴検索モード - ファイルI/O（補助） | E-04 (HistoryFile読み込み) | ○ |
| C-44 | 履歴検索モード - テキスト出力（補助） | E-04 (ANSIエスケープによる描画) | ○ |
| C-45 | プレフィックス検索モード - REPL（主機能） | E-03 (PrefixHistoryPrompt定義) | ○ |
| C-46 | プレフィックス検索モード - 文字列検索・置換（主機能） | E-03 (startswith前方一致) | ○ |
| C-47 | プレフィックス検索モード - ファイルI/O（補助） | E-03, E-04 (履歴ファイル読み込み) | ○ |
| C-48 | プレフィックス検索モード - テキスト出力（補助） | E-03 (プロンプトバッファ表示) | ○ |
| C-49 | RadioMenu - REPL（主機能） | E-05 (RadioMenu in TerminalMenus) | ○ |
| C-50 | RadioMenu - テキスト出力（主機能） | E-05 (print/IOBuffer描画) | ○ |
| C-51 | RadioMenu - IOストリーム（補助） | E-05 (IOBuffer使用) | ○ |
| C-52 | RadioMenu - Array（補助） | E-05 (options::Array{String,1}) | ○ |
| C-53 | MultiSelectMenu - REPL（主機能） | E-06 (MultiSelectMenu in TerminalMenus) | ○ |
| C-54 | MultiSelectMenu - テキスト出力（主機能） | E-06 (print/IOBuffer描画) | ○ |
| C-55 | MultiSelectMenu - 集合（補助） | E-06 (selected::Set{Int}) | ○ |
| C-56 | MultiSelectMenu - IOストリーム（補助） | E-06 (IOBuffer使用) | ○ |
| C-57 | MultiSelectMenu - Array（補助） | E-06 (options::Array{String,1}) | ○ |
| C-58 | Pager - REPL（主機能） | E-07 (Pager in TerminalMenus) | ○ |
| C-59 | Pager - テキスト出力（主機能） | E-07 (print描画) | ○ |
| C-60 | Pager - マルチメディアI/O（補助） | E-07 (show(ctx, "text/plain", object)) | ○ |
| C-61 | Pager - IOストリーム（補助） | E-07 (IOBuffer/IOContext使用) | ○ |
| C-62 | Pager - 文字列分割・結合（補助） | E-07 (readlines(IOBuffer(text))) | ○ |
| C-63 | フォールバックREPL - eval（主機能） | E-08 (eval_user_input呼び出し) | ○ |
| C-64 | フォールバックREPL - テキスト出力（主機能） | E-08 (print("julia> "), flush(stdout)) | ○ |
| C-65 | フォールバックREPL - 式オブジェクト（補助） | E-08 (parse_input_line -> :toplevel) | ○ |
| C-66 | フォールバックREPL - ファイルI/O（補助） | E-08 (stdin read/readline) | ○ |
| C-67 | フォールバックREPL - エラー表示（補助） | E-08 (display_error, current_exceptions()) | ○ |
| C-68 | フォールバックREPL - 例外機構（補助） | E-08 (try/catch in repl loop) | ○ |
| C-69 | フォールバックREPL - パーサー（補助） | E-08 (parse_input_line) | ○ |
| C-70 | フォールバックREPL - 標準入出力（補助） | E-08 (stdin/stdout/stderr直接使用) | ○ |
| C-71 | Juliaプロンプト - Pkg（遷移先）：Pkg.jl遅延読み込み | E-01 (L1437-1449: Threads.@spawn Pkg require) | ○ |

## 4) 不足情報（Unknown / Missing）
- **Pkgモード - Artifacts/TOML連携**：Pkg.jlは外部パッケージ（stdlib/Pkg.version参照）のため、内部実装の直接的なコード確認ができなかった。Artifacts/TOMLの利用はPkg.jlの一般的な動作から推定。
  - 候補：stdlib/Pkg.version 内の実コード / Pkg.jlリポジトリのソースコード / Pkg.jlドキュメント
- **Juliaプロンプト - ロギング連携**：@info等のマクロがREPL画面に出力されることは確実だが、REPL側での明示的なロギング統合コードの特定が間接的。
  - 候補：base/logging/ConsoleLogger.jl / stdlib/Logging/src/Logging.jl
- **Juliaプロンプト - InteractiveUtils連携**：import InteractiveUtilsの宣言は確認済みだが、REPL画面としての直接的な統合コードパスは未確認。
  - 候補：stdlib/InteractiveUtils/src/InteractiveUtils.jl
- **ヘルプモード - 型リフレクション**：`using InteractiveUtils: subtypes` の宣言は確認済みだが、helpmode内での直接的なsubtypes呼び出しパスの詳細確認が不足。
  - 候補：stdlib/REPL/src/docview.jl の全体コード精査

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体として画面一覧・機能一覧の双方のNo/名称を正確に参照しており、ソースコードとの整合性は高い
- 1: 中リスク - Pkgモードに関連するArtifacts/TOML連携は、Pkg.jlが外部パッケージであるため直接確認不可。実際の連携有無はPkg.jl側のコード確認が必要
- 0: 低リスク - 各画面の主機能・補助機能・遷移先機能の分類は、ソースコード上の実装構造と一致している
- 1: 中リスク - 機能一覧150件中、画面と関連付けられたのは約30件の機能のみ。残りはバックエンド機能（型システム、コンパイラ、ランタイム等）であり画面との直接関連が無いことは妥当だが、一部見落としの可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] 画面No/画面名が画面一覧.csvの値と完全一致しているか
- [ ] 機能No/機能名が機能一覧.csvの値と完全一致しているか
- [ ] 関連種別（主機能/補助機能/遷移先機能/API連携）が各マッピングの実態と合致しているか
- [ ] Pkgモード - Artifacts/TOML連携が実際にPkg.jl内部で使用されているか（外部パッケージのため要確認）
- [ ] ロギング機能のREPL画面への統合パスが正確か
- [ ] 1つの画面に対して主機能が少なくとも1つ割り当てられているか
- [ ] 全11画面がマッピング表に含まれているか
- [ ] 遷移先機能として指定された画面間の遷移パスがコード上で確認できるか
