# 画面設計書 1-起動バナー画面

## 概要

Juliaプロセス起動時に表示されるASCIIアートのロゴバナー画面の設計書。バージョン情報、コミット情報、ドキュメントURLをターミナルに出力する。

### 本画面の処理概要

本画面は、Juliaプロセスの起動直後にユーザーに対して表示される初期画面であり、Julia REPLセッションの最初の視覚的要素として機能する。

**業務上の目的・背景**：Juliaの対話環境（REPL）を起動した際に、ユーザーが現在使用しているJuliaのバージョン、ビルド情報（コミットハッシュ・ブランチ名）、公式ドキュメントへのURLを即座に確認できるようにすることが目的である。特に開発用ビルドでは、フォーク元からの距離（コミット数・日数）が表示され、ビルドの鮮度を把握できる。これにより、バグ報告時のバージョン確認やドキュメント参照が容易になる。

**画面へのアクセス方法**：Juliaプロセスを起動すると自動的に表示される。コマンドラインオプション `--banner=no` で非表示、`--banner=short` で短縮版を選択可能。`--banner=yes`（デフォルト、対話モード時）で完全版が表示される。

**主要な操作・処理内容**：
1. `banner()` 関数がJuliaのASCIIアートロゴを標準出力に描画する
2. 端末がカラー対応の場合、ロゴの各ドットに青・赤・緑・マゼンタの色を付与する
3. バージョン番号（`VERSION`）とコミット日付を表示する
4. タグ付きリリースの場合はリリースバナー、開発ビルドの場合はブランチ名・コミットハッシュ・フォーク距離を表示する
5. ドキュメントURL（https://docs.julialang.org）とヘルプ起動のヒント（`?` キー、`]?` キー）を表示する

**画面遷移**：本画面はバナー表示完了後、自動的にJuliaプロンプト（julia>）画面に遷移する。REPL読込失敗時またはダム端末の場合はフォールバックREPLに遷移する。本画面への遷移元は、OS上でのJuliaプロセス起動のみである。

**権限による表示制御**：権限による表示制御は存在しない。コマンドラインオプション（`--banner`）による表示制御のみが存在する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | テキスト出力 | 主機能 | banner()関数がprint/printlnを使用してASCIIアートロゴ・バージョン情報・コミット情報をstdoutに出力する |
| 96 | コマンドラインインタフェース | 補助機能 | --banner=no/short オプションによるバナー表示制御。jl_parse_optsで解析されたオプションに基づきバナー表示を切り替える |
| 102 | REPL | 補助機能 | REPLモジュール内のbanner()関数として実装。REPLセッション開始時に自動呼び出しされる |

## 画面種別

情報表示（起動時の自動出力画面）

## URL/ルーティング

該当なし（ターミナルベースのCLIアプリケーション。URLルーティングは存在しない）

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| io | 入力 | IO | 出力先のIOストリーム（デフォルト: stdout） |
| short | 入力 | Bool | true: 短縮版バナー、false: 完全版バナー（デフォルト: false） |
| バナーテキスト | 出力 | String | ASCIIアートロゴ・バージョン情報・コミット情報を含むテキスト |

## 表示項目

| 項目名 | 表示内容 | 条件 |
|--------|----------|------|
| ASCIIアートロゴ | Juliaのロゴをテキストアートで表示 | short=false のとき表示。カラー端末ではドットに色付き |
| 短縮ロゴ | 2行のドットパターン | short=true のとき表示 |
| ドキュメントURL | `Documentation: https://docs.julialang.org` | short=false のとき表示 |
| ヘルプヒント | `Type "?" for help, "]?" for Pkg help.` | short=false のとき表示 |
| バージョン | `Version {VERSION}({commit_date})` | 常に表示 |
| コミット情報 | タグ付きリリース: TAGGED_RELEASE_BANNER / 開発ビルド: `{branch}/{commit} (fork: {distance} commits, {days} days)` | 常に表示 |

## イベント仕様

### 1-バナー表示

バナーはREPLフロントエンドの開始時に自動的に呼び出される。`run_frontend()` 内で `banner(repl.stream)` または `banner(io; short=...)` として実行される。表示完了後、制御はREPLの入力ループに移行する。

## データベース更新仕様

### 操作別データベース影響一覧

該当なし（データベースを使用しない）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| - | 情報 | ASCIIアートバナー + バージョン情報 | Juliaプロセス起動時（--banner=no 以外） |

## 例外処理

| 例外 | 発生条件 | 対応 |
|------|----------|------|
| IOストリームエラー | 出力先IOが利用不可の場合 | 上位の例外処理に委ねる |

## 備考

- カラー端末では `Base.text_colors` を使用してロゴの各部位に色を付与する（青・赤・緑・マゼンタ）
- `Base.GIT_VERSION_INFO` 構造体からビルド情報（コミットハッシュ、日付、ブランチ名、フォーク距離）を取得する
- `short=true` の場合は2行のコンパクトなバナーが表示される
- StreamREPL, LineEditREPL の両方で `banner()` が呼び出される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

バナー表示に必要なデータは `Base.GIT_VERSION_INFO` 構造体と `VERSION` 定数に格納されている。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | version_git.jl | `base/version_git.jl` | GIT_VERSION_INFO構造体の定義。commit, commit_short, branch, fork_master_distance, fork_master_timestamp, date_string フィールドを確認 |
| 1-2 | version.jl | `base/version.jl` | VERSION定数の定義とVersionNumber型の構造を確認 |

**読解のコツ**: `Base.GIT_VERSION_INFO` はビルド時に生成される情報であり、実行時に動的に変わることはない。`tagged_commit` フラグでリリース版と開発版の表示が分岐する。

#### Step 2: エントリーポイントを理解する

バナー表示のエントリーポイントは `banner()` 関数である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | REPL.jl | `stdlib/REPL/src/REPL.jl` | banner()関数の定義（1735行目〜1803行目）。引数 `io`, `short` の処理とカラー分岐を確認 |

**主要処理フロー**:
1. **1736-1753行**: コミット情報文字列の構築。`tagged_commit` でリリース版/開発版を分岐
2. **1755行**: コミット日付文字列の構築
3. **1757-1802行**: カラー/非カラー、short/完全版の4パターンで表示分岐
4. **1761-1764行**: カラー端末でのドット色定義（d1=青, d2=赤, d3=緑, d4=マゼンタ）

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | REPL.jl | `stdlib/REPL/src/REPL.jl` | run_frontend(repl::StreamREPL)内のbanner()呼び出し（1808行目） |
| 3-2 | REPL.jl | `stdlib/REPL/src/REPL.jl` | run_frontend(repl::LineEditREPL)内のbanner()呼び出し |
| 3-3 | client.jl | `base/client.jl` | --bannerオプションの解析と制御。exec_options()内でバナー表示の有無を決定 |

**主要処理フロー**:
- **1808行**: `banner(repl.stream)` でStreamREPLのフロントエンド開始時にバナー表示

### プログラム呼び出し階層図

```
Juliaプロセス起動
    |
    +-- base/client.jl: exec_options()
    |       |
    |       +-- --banner オプション解析
    |
    +-- stdlib/REPL/src/REPL.jl: run_frontend()
            |
            +-- banner(io; short=false)  [1735行]
                    |
                    +-- Base.GIT_VERSION_INFO 参照
                    +-- Base.TAGGED_RELEASE_BANNER 参照
                    +-- VERSION 参照
                    +-- print(io, ...) でターミナルに出力
```

### データフロー図

```
[入力]                     [処理]                          [出力]

Base.GIT_VERSION_INFO ---> banner() 関数              ---> stdout (ターミナル)
Base.VERSION          --->   commit_string 構築        --->   ASCIIアートロゴ
IO (stdout)           --->   カラー判定                --->   バージョン情報
short フラグ          --->   テンプレート選択          --->   コミット情報
                             print() で出力            --->   ドキュメントURL
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| REPL.jl | `stdlib/REPL/src/REPL.jl` | ソース | banner()関数の定義（1735-1803行）。メインのバナー描画ロジック |
| client.jl | `base/client.jl` | ソース | --bannerオプションの解析。repl_cmd()定義 |
| version_git.jl | `base/version_git.jl` | ソース | GIT_VERSION_INFO構造体の定義 |
| version.jl | `base/version.jl` | ソース | VERSION定数の定義 |
| options.jl | `stdlib/REPL/src/options.jl` | ソース | REPLオプション設定 |
