---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：1-起動バナー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **exec_options()内のバナー制御**: client.jlの該当箇所の詳細確認が必要
  2. **version_git.jlのGIT_VERSION_INFO構造体**: ビルドシステムとの連携を確認必要
  3. **TAGGED_RELEASE_BANNER定数**: 定義場所の特定が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `stdlib/REPL/src/REPL.jl` 1735-1803行 - banner()関数定義
- E-02: `stdlib/REPL/src/REPL.jl` 1808行 - run_frontend()内のbanner()呼び出し
- E-03: `stdlib/REPL/src/REPL.jl` 113-116行 - プロンプト定数定義（JULIA_PROMPT等）
- E-04: `base/client.jl` 34-79行 - repl_cmd()関数定義
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-06: `docs/code-to-docs/画面遷移図.md` - 画面遷移定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | banner()関数がASCIIアートロゴを描画する | E-01 | ○ |
| C-02 | カラー端末ではドットに青・赤・緑・マゼンタの色を付与する | E-01 (1761-1764行) | ○ |
| C-03 | --banner=no/shortオプションで制御可能 | E-05, E-07 | ○ |
| C-04 | short=trueで2行のコンパクトバナーを表示 | E-01 (1766-1770行, 1784-1789行) | ○ |
| C-05 | バージョン番号とコミット日付を表示する | E-01 (1755行, 1777行) | ○ |
| C-06 | tagged_commitでリリース版/開発版の表示が分岐する | E-01 (1736行) | ○ |
| C-07 | 開発ビルドではブランチ名・コミットハッシュ・フォーク距離を表示 | E-01 (1750-1752行) | ○ |
| C-08 | ドキュメントURL（docs.julialang.org）を表示する | E-01 (1773行) | ○ |
| C-09 | ヘルプヒント（?キー、]?キー）を表示する | E-01 (1775行) | ○ |
| C-10 | StreamREPLのrun_frontend()でbanner()が呼び出される | E-02 | ○ |
| C-11 | バナー表示後、自動的にJuliaプロンプトに遷移する | E-02, E-06 | ○ |
| C-12 | REPL読込失敗時にフォールバックREPLに遷移する | E-06 | ○ |
| C-13 | Base.GIT_VERSION_INFOからビルド情報を取得する | E-01 (1736-1752行) | ○ |
| C-14 | banner()のデフォルト引数はio=stdout, short=false | E-01 (1735行) | ○ |
| C-15 | フォーク距離はccall(:jl_clock_now)で計算される | E-01 (1741行) | ○ |
| C-16 | client.jlのexec_options()でバナー表示有無を決定する | **根拠なし** | △ |
| C-17 | 関連機能として機能No.36(テキスト出力),96(CLI),102(REPL)が存在する | E-07 | ○ |
| C-18 | LineEditREPLでもbanner()が呼び出される | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-16: exec_options()内のバナー制御の具体的な実装箇所をclient.jl内で確認する必要がある。画面一覧CSVの備考に「--banner=no/short オプションで制御可能」とあるが、exec_options()の具体的な行番号は未確認。
  - 候補：`base/client.jl` の exec_options() / `src/jloptions.c` の jl_parse_opts()

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - バナー表示は読み取り専用の表示処理であり、副作用やデータ更新がないため安全
- 1: 中リスク - カラーコード処理の正確性（端末互換性）の確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] banner()関数の引数（io, short）の記述が正しいか確認
- [ ] カラー端末での色指定（d1=青, d2=赤, d3=緑, d4=マゼンタ）が正しいか確認
- [ ] --bannerオプションの制御フローが正しく記述されているか確認
- [ ] 画面遷移（バナー表示後→Juliaプロンプト、REPL読込失敗→フォールバックREPL）が正しいか確認
