---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：11-フォールバックREPL

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **C-31 ダム端末での自動フォールバック挙動**：ダム端末判定はrun_std_repl内のBasicREPL分岐であり、フォールバックREPLへの直接遷移パスが不明確
  2. **C-32 File/IOStream入力時のIOエラーハンドリング**：一括読み込みモードでのIOエラー処理の明示的なコードが未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/client.jl` 442-482行目 - `run_fallback_repl()`関数の実装
- E-02: `base/client.jl` 515-534行目 - `run_main_repl()`関数（フォールバック分岐ロジック）
- E-03: `base/client.jl` 127-174行目 - `eval_user_input()`関数の実装
- E-04: `base/client.jl` 108-121行目 - `display_error()`関数群
- E-05: `base/client.jl` 92-102行目 - `scrub_repl_backtrace()`関数
- E-06: `base/client.jl` 176-203行目 - `parse_input_line()`と`_parse_input_line_core()`
- E-07: `base/client.jl` 208-232行目 - `incomplete_tag()`と`fl_incomplete_tag()`
- E-08: `base/client.jl` 575-613行目 - `_start()`関数
- E-09: `base/client.jl` 615-627行目 - `repl_main()`関数
- E-10: `base/client.jl` 537-566行目 - `MainInclude`モジュール定義（ans, err変数）
- E-11: `base/client.jl` 124-125行目 - `__repl_entry_client_lower()`と`__repl_entry_client_eval()`
- E-12: `base/meta.jl` 414-417行目 - `Meta.parseall()`関数
- E-13: `base/errorshow.jl` 1104-1117行目 - `show_exception_stack()`関数
- E-14: `base/options.jl` 86-96行目 - `colored_text()`関数
- E-15: `doc/src/manual/environment-variables.md` 597-599行目 - JULIA_FALLBACK_REPL環境変数ドキュメント
- E-16: `pkgimage.mk` 15行目 - `JULIA_FALLBACK_REPL := true`設定
- E-17: `contrib/generate_precompile.jl` 299行目 - `JULIA_FALLBACK_REPL => "true"`設定
- E-18: `base/client.jl` 429-437行目 - `load_REPL()`関数
- E-19: `base/client.jl` 413-427行目 - `load_InteractiveUtils()`関数
- E-20: `docs/code-to-docs/画面一覧/画面遷移図.md` 46-51行目 - フォールバックREPLの遷移定義
- E-21: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 64-71行目 - フォールバックREPLの機能マッピング
- E-22: `docs/code-to-docs/画面一覧/画面一覧.csv` 12行目 - フォールバックREPLの画面定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フォールバックREPLはREPL.jl読み込み失敗時に使用される | E-02（525-531行目: REPL !== Baseの判定とrun_fallback_repl呼び出し）, E-18 | ○ |
| C-02 | フォールバックREPLは行編集・補完・履歴機能を持たない | E-01（442-482行目: readline/printのみ使用、LineEdit等の参照なし） | ○ |
| C-03 | JULIA_FALLBACK_REPL環境変数で強制起動可能 | E-02（516行目: parse(Bool, get(ENV, "JULIA_FALLBACK_REPL", "false"))）, E-15 | ○ |
| C-04 | プロンプト文字列は"julia> "固定 | E-01（460行目: print("julia> ")） | ○ |
| C-05 | flush(stdout)でプロンプトを即時表示 | E-01（461行目: flush(stdout)） | ○ |
| C-06 | interactiveフラグでプロンプト表示を制御 | E-01（459行目: if interactive） | ○ |
| C-07 | eof(input)でループ終了を判定 | E-01（463行目: eof(input) && break） | ○ |
| C-08 | parse_input_lineで構文解析を行う | E-01（469行目）, E-06（192行目） | ○ |
| C-09 | :incomplete式の場合は追加行を読み込む | E-01（470行目: ex.head === :incomplete判定）, E-07 | ○ |
| C-10 | eval_user_inputで式評価を行う | E-01（474行目）, E-03（127行目） | ○ |
| C-11 | 評価結果をans変数に格納 | E-03（145行目: setglobal!(Base.MainInclude, :ans, value)）, E-10 | ○ |
| C-12 | エラー時にerr変数にエラー情報を格納 | E-03（138行目, 165行目: setglobal!(Base.MainInclude, :err, lasterr)）, E-10 | ○ |
| C-13 | display_errorでエラーメッセージ表示 | E-03（139行目）, E-04（108-121行目） | ○ |
| C-14 | "ERROR: "プレフィックスを赤色太字で表示 | E-04（109行目: printstyled(io, "ERROR: "; bold=true, color=Base.error_color())） | ○ |
| C-15 | scrub_repl_backtraceでREPL関連フレームを除去 | E-05（92-102行目: __repl_entryプレフィックスによるフィルタリング） | ○ |
| C-16 | errcount > 2で致命的エラーとしてループ中断 | E-03（166-169行目） | ○ |
| C-17 | display_error自体のエラー時にSYSTEMエラーメッセージ出力 | E-03（161行目: @error "SYSTEM: display_error..."） | ○ |
| C-18 | InterruptExceptionを捕捉して改行2つ出力 | E-01（476行目: isa(err, InterruptException) ? print("\n\n") : rethrow()） | ○ |
| C-19 | File/IOStream入力時は全体を一括読み込み | E-01（444-456行目: isa(input, File) \|\| isa(input, IOStream)判定、read(input, String)） | ○ |
| C-20 | :toplevel式の場合は各文を順次評価 | E-01（447-453行目: Meta.isexpr(ex, :toplevel)判定とex.argsのループ） | ○ |
| C-21 | _start()がJuliaプロセスの最初のエントリーポイント | E-08（575行目） | ○ |
| C-22 | repl_main()でバナー/quiet/history_fileオプションを解析 | E-09（615-627行目） | ○ |
| C-23 | REPL読み込み失敗かつquiet==falseの場合に警告メッセージ表示 | E-02（528-529行目: if !fallback_repl && interactive && !quiet → @warn） | ○ |
| C-24 | 警告メッセージに"REPL provider not available: using basic fallback"を表示 | E-02（529行目） | ○ |
| C-25 | pkgimage.mkでJULIA_FALLBACK_REPL=trueが設定される | E-16（15行目: export JULIA_FALLBACK_REPL := true） | ○ |
| C-26 | generate_precompile.jlでJULIA_FALLBACK_REPL=trueが使用される | E-17（299行目） | ○ |
| C-27 | Core.eval(Main, ast)で式を評価 | E-11（125行目: __repl_entry_client_eval(mod, ast) = Core.eval(mod, ast)） | ○ |
| C-28 | Meta.parseallでJuliaSyntaxベースのパーサーを呼び出す | E-06（177行目）, E-12（414行目） | ○ |
| C-29 | 評価成功だがdisplayエラー時に"Evaluation succeeded..."メッセージ出力 | E-03（153行目: @error "Evaluation succeeded, but an error occurred while displaying the value"） | ○ |
| C-30 | カラー対応時はanswer_color()で色付け | E-03（148行目: print(answer_color())） | ○ |
| C-31 | ダム端末からのアクセスでフォールバックREPLが起動する | E-20（画面遷移図）, E-22（画面一覧） | △ |
| C-32 | File/IOStream入力時のIOエラーは通常のエラーハンドリングに委譲 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-31（ダム端末でのフォールバック起動）**: 画面遷移図と画面一覧CSVにはダム端末での遷移が記載されているが、実際のコード上では`run_std_repl()`内でダム端末はBasicREPLとして処理される（`base/client.jl` 488-490行目）。フォールバックREPLへの直接的な遷移パスは、REPL.jl読み込み失敗時のみであり、ダム端末=フォールバックREPLという対応は正確ではない可能性がある。
  - 候補：`stdlib/REPL/src/REPL.jl`のBasicREPL実装 / REPLの初期化失敗パス / `term_type == "dumb"`分岐の詳細確認
- **C-32（File/IOStream入力のIOエラー処理）**: 一括読み込みモードでIOエラーが発生した場合の明示的なエラーハンドリングコードが`run_fallback_repl()`内に存在しない。`read(input, String)`が例外を投げた場合、上位の`_start()`内の`try/catch`で捕捉される可能性がある。
  - 候補：`base/client.jl`の`_start()`内catchブロック / `base/io.jl`のread実装 / Juliaの標準例外伝播メカニズム

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 主要な関数実装（run_fallback_repl, eval_user_input, parse_input_line, display_error）はすべてソースコードで直接確認済み
- **1（中リスク）**: ダム端末でのフォールバックREPL起動パスの正確性。画面遷移図の記載と実コードの挙動に乖離の可能性あり
- **0（低リスク）**: 環境変数JULIA_FALLBACK_REPLによる強制起動はコードとドキュメントの両方で確認済み
- **0（低リスク）**: エラーハンドリングのerrcount段階的処理はコードで直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] C-31: ダム端末（TERM=dumb）時にフォールバックREPLが起動するか、それともBasicREPLが起動するかを実機で確認する
- [ ] C-32: File/IOStream入力モードでIOエラー（ファイル読み込み失敗等）が発生した場合の挙動を確認する
- [ ] プロンプト文字列"julia> "が意図通りの表示であることを確認する（標準REPLとの差異認識）
- [ ] InterruptException（Ctrl+C）でREPLが正しく継続することを確認する
- [ ] errcount > 2での致命的エラーメッセージが適切であることを確認する
