---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-RadioMenu（単一選択メニュー）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **printmenu()の描画詳細**: カーソルインジケータとスクロールインジケータの正確な表示ロジック
  2. **レガシーインタフェースの互換性**: writeLine vs writeline の使い分け
  3. **raw modeのエラーハンドリング**: 端末がraw modeに対応しない場合の動作

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/REPL/src/TerminalMenus/RadioMenu.jl` 22-109行 - RadioMenu型全体
- E-02: `stdlib/REPL/src/TerminalMenus/AbstractMenu.jl` 52-299行 - AbstractMenu, request(), move系関数
- E-03: `stdlib/REPL/src/TerminalMenus/config.jl` 1-184行 - Config, MultiSelectConfig
- E-04: `stdlib/REPL/src/TerminalMenus/TerminalMenus.jl` 1-44行 - モジュール定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RadioMenuが_ConfiguredMenu{C}を継承する | E-01 (22行) | ○ |
| C-02 | options, keybindings, pagesize, pageoffset, selected, configフィールドを持つ | E-01 (23-29行) | ○ |
| C-03 | コンストラクタがoptions長のバリデーションを行う | E-01 (54行) | ○ |
| C-04 | pagesize=-1で自動ページング | E-01 (58行) | ○ |
| C-05 | keybindingsは0個かoptions数と同数でなければエラー | E-01 (55行) | ○ |
| C-06 | pick()がmenu.selected=cursorを設定しtrueを返す | E-01 (85-88行) | ○ |
| C-07 | cancel()がmenu.selected=-1を設定する | E-01 (83行) | ○ |
| C-08 | writeline()で改行を\\nに置換して表示する | E-01 (91行) | ○ |
| C-09 | keypress()でkeybindings対応キーにより即座に選択する | E-01 (94-100行) | ○ |
| C-10 | request()がraw modeでメインループを実行する | E-02 (191-197行) | ○ |
| C-11 | カーソルが非表示にされ終了時に復元される | E-02 (199行, 241行) | ○ |
| C-12 | move_up!()とmove_down!()でカーソル移動する | E-02 (263-290行) | ○ |
| C-13 | scroll_wrapでラップアラウンドする | E-02 (269-273行) | ○ |
| C-14 | qキーでcancel()が呼ばれる | E-02 (223-225行) | ○ |
| C-15 | Ctrl+Cでctrl_c_interrupt設定に応じて動作する | E-02 (226-228行) | ○ |
| C-16 | Config構造体が6つのフィールドを持つ | E-03 (5-12行) | ○ |
| C-17 | :asciiと:unicodeの2つのcharsetをサポートする | E-03 (53-54行) | ○ |
| C-18 | 4種類の関連機能が存在する | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UIコンポーネントとしての単一選択は明確な動作
- 0: 低リスク - raw modeのfinally節による確実な復元

## 6) レビュアーチェックリスト（最小）
- [ ] RadioMenu構造体のフィールドと型が正しいか確認
- [ ] request()のメインループ内のキー処理が正しいか確認
- [ ] Config構造体の:ascii/:unicode切り替えが正しいか確認
