---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-MultiSelectMenu（複数選択メニュー）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  1. **RadioMenuとの動作差異**: EnterキーがトグルであることのUI上の明確さ
  2. **MultiSelectConfigの設定詳細**: checked/unchecked文字列のカスタマイズ範囲
  3. **レガシーインタフェースの互換性**: writeLine vs writeline

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/REPL/src/TerminalMenus/MultiSelectMenu.jl` 30-143行 - MultiSelectMenu型全体
- E-02: `stdlib/REPL/src/TerminalMenus/AbstractMenu.jl` 181-247行 - request()
- E-03: `stdlib/REPL/src/TerminalMenus/config.jl` 14-18行, 70-100行 - MultiSelectConfig
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MultiSelectMenuが_ConfiguredMenu{C}を継承する | E-01 (30行) | ○ |
| C-02 | selected フィールドがSet{Int}型である | E-01 (34行) | ○ |
| C-03 | optionsが空の場合エラーが発生する | E-01 (59行) | ○ |
| C-04 | selected引数で初期選択状態を指定可能 | E-01 (58行, 69-72行) | ○ |
| C-05 | header()が操作ヒント文字列を返す | E-01 (89行) | ○ |
| C-06 | pick()でEnterがトグル動作する（push!/delete!） | E-01 (96-104行) | ○ |
| C-07 | pick()がfalseを返す（ループを終了しない） | E-01 (103行) | ○ |
| C-08 | cancel()がSet{Int}()を設定する | E-01 (93行) | ○ |
| C-09 | d/Dキーでkeypress()がtrueを返す | E-01 (120-121行) | ○ |
| C-10 | a/Aキーで全選択する | E-01 (122-123行) | ○ |
| C-11 | n/Nキーで全解除する | E-01 (124-125行) | ○ |
| C-12 | writeline()でchecked/unchecked表示する | E-01 (106-114行) | ○ |
| C-13 | MultiSelectConfigがconfig+checked+uncheckedを持つ | E-03 (14-18行) | ○ |
| C-14 | :asciiでchecked="[X]", unchecked="[ ]" | E-03 (93-94行) | ○ |
| C-15 | :unicodeでchecked="v", unchecked="?" | E-03 (95-96行) | ○ |
| C-16 | request()のメインループはRadioMenuと共通 | E-02 | ○ |
| C-17 | 5種類の関連機能が存在する | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UIコンポーネントとしての複数選択は明確な動作
- 0: 低リスク - RadioMenuとの共通インフラ使用により信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] MultiSelectMenu構造体のselectedフィールドがSet{Int}であることを確認
- [ ] pick()のトグル動作（push!/delete!）が正しいか確認
- [ ] keypress()のd/a/nキー処理が正しいか確認
- [ ] header()の表示文字列が正しいか確認
