---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 79
  claims_with_evidence: 79
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧

## 本レポートについて

### 目的
本レポートは、生成された通知一覧ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：79 / 79、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全ての通知はソースコード内の@warn/@info/@error/@debug/depwarnマクロの直接的な使用箇所から抽出されており、根拠は全て確認済み

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/cmd.jl` （行197: @warn "For portability use devnull..."）
- E-02: `base/env.jl` （行209, 223: @warn "malformed environment entry"）
- E-03: `base/process.jl` （行323: @warn "Process I/O error"）
- E-04: `base/initdefs.jl` （行282: @warn "Failed to initialize named environment"）
- E-05: `base/initdefs.jl` （行552: @warn "a hook from a library to disable threading failed"）
- E-06: `base/secretbuffer.jl` （行191: @warn "a SecretBuffer was shred!ed by the GC"）
- E-07: `base/loading.jl` （行1005: @warn "Failed to read project"）
- E-08: `base/loading.jl` （行2747: @warn "Replacing module"）
- E-09: `base/loading.jl` （行2847: @warn "Module...is missing from the cache"）
- E-10: `base/loading.jl` （行2912, 2919: @warn "The call to compilecache failed"）
- E-11: `base/loading.jl` （行4516: @warn "Inactive precompile statement"）
- E-12: `base/file.jl` （行580, 582: @warn "tempdir path does not exist"/"is not a directory"）
- E-13: `base/file.jl` （行700: @warn "Failed to clean up temporary path"）
- E-14: `base/binaryplatforms.jl` （行930: @warn "Unable to determine libgfortran version"）
- E-15: `base/binaryplatforms.jl` （行996: @warn "Unable to find llvm::sys::getProcessTriple()"）
- E-16: `base/precompilation.jl` （行817: @warn excluded_circular_deps_explanation）
- E-17: `base/client.jl` （行271: @warn "Unexpected command"）
- E-18: `base/client.jl` （行422: @warn "Failed to import InteractiveUtils"）
- E-19: `base/client.jl` （行434: @warn "Failed to import REPL"）
- E-20: `base/client.jl` （行490: @warn "Terminal not fully functional"）
- E-21: `base/client.jl` （行529: @warn "REPL provider not available"）
- E-22: `base/docs/Docs.jl` （行253: @warn "Replacing docs"）
- E-23: `base/terminfo_data.jl` （行59, 67, 80, 90: @warn "Malformed line"/"Unrecognised capability/data type"）
- E-24: `base/deprecated.jl` （行390: @warn "@get! is deprecated"）
- E-25: `base/experimental.jl` （行329: @error "Hint-handler caused an error"）
- E-26: `base/gmp.jl` （行114: @error/@warn GMP bits mismatch）
- E-27: `base/Base.jl` （行349: @error "Profile printing listener crashed"）
- E-28: `base/errorshow.jl` （行401: @error "Error showing method candidates"）
- E-29: `base/file.jl` （行914, 945: @error "mktemp cleanup"/"mktempdir cleanup"）
- E-30: `base/client.jl` （行153: @error "Evaluation succeeded, but an error occurred while displaying"）
- E-31: `base/client.jl` （行161: @error "SYSTEM: display_error caused an error"）
- E-32: `base/client.jl` （行167: @error "It is likely that something important is broken"）
- E-33: `base/client.jl` （行602: @error "The return value of main should be nothing or convertible to Cint"）
- E-34: `base/loading.jl` （行1627: @error "Error during package callback"）
- E-35: `base/loading.jl` （行1774: @error "Error during loading of extension"）
- E-36: `base/initdefs.jl` （行383: @error "active project callback failed"）
- E-37: `stdlib/Sockets/src/Sockets.jl` （行616: @warn "Networking unoptimized"）
- E-38: `stdlib/Profile/src/Profile.jl` （行151: @warn "Requested profile buffer limited to 512MB"）
- E-39: `stdlib/Profile/src/Profile.jl` （行294: @warn "Profiling on windows is limited to the main thread"）
- E-40: `stdlib/Profile/src/Profile.jl` （行693: @warn "The profile data buffer is full"）
- E-41: `stdlib/Profile/src/Profile.jl` （行1462: @warn "Cannot write to current directory"）
- E-42: `stdlib/Profile/src/heapsnapshot_reassemble.jl` （行174: @warn "Bug in to_pos"）
- E-43: `stdlib/Profile/src/Allocs.jl` （行226: @warn アロケーション停止メッセージ）
- E-44: `stdlib/InteractiveUtils/src/editless.jl` （行111: @warn "invalid editor value returned"）
- E-45: `stdlib/InteractiveUtils/src/InteractiveUtils.jl` （行350: @info "Loading BugReporting package..."）
- E-46: `stdlib/InteractiveUtils/src/InteractiveUtils.jl` （行355: @info "Package BugReporting not found"）
- E-47: `stdlib/FileWatching/src/pidfile.jl` （行198: @warn "filesystem time skew detected"）
- E-48: `stdlib/FileWatching/src/pidfile.jl` （行248, 301: @warn "attempting to remove probably stale pidfile"）
- E-49: `stdlib/FileWatching/src/pidfile.jl` （行370: @warn "failed to remove pidfile on close"）
- E-50: `stdlib/REPL/src/History/histfile.jl` （行122, 167, 173: @warn "Malformed history entry/content"）
- E-51: `stdlib/REPL/src/REPL.jl` （行179: @warn "is not public in"）
- E-52: `stdlib/REPL/src/REPL.jl` （行1383: @info "Disabling history file for this session"）
- E-53: `stdlib/REPL/src/REPL.jl` （行1637: @info "edit failed"）
- E-54: `stdlib/REPL/src/LineEdit.jl` （行3005: @error "Error in the keymap"）
- E-55: `stdlib/REPL/src/StylingPasses.jl` （行63: @error "Error in SyntaxHighlightPass"）
- E-56: `stdlib/REPL/src/StylingPasses.jl` （行106: @error "Error in EnclosingParenHighlightPass"）
- E-57: `stdlib/REPL/src/docview.jl` （行943: @warn "Unable to search documentation"）
- E-58: `stdlib/REPL/src/TerminalMenus/AbstractMenu.jl` （行195: @warn "Unable to enter raw mode"）
- E-59: `stdlib/LibGit2/src/merge.jl` （行159: @info "Review and commit merged changes"）
- E-60: `stdlib/LibGit2/src/merge.jl` （行222, 235: @warn "Unable to perform Fast-Forward merge"）
- E-61: `stdlib/LibGit2/src/merge.jl` （行241: @warn "Cannot perform fast-forward merge"）
- E-62: `stdlib/LibGit2/src/LibGit2.jl` （行465: @warn "Please provide remote tracking for branch"）
- E-63: `stdlib/LibGit2/src/gitcredential.jl` （行134: @warn "Unknown git credential attribute found"）
- E-64: `stdlib/LibGit2/src/callbacks.jl` （行419: @error "unexpected SSH known host check result"）
- E-65: `stdlib/LibGit2/src/callbacks.jl` （行423: @error "unexpected transport encountered"）
- E-66: `stdlib/LibGit2/src/callbacks.jl` （行475: @warn "Error parsing SSH known hosts file"）
- E-67: `stdlib/LibGit2/src/callbacks.jl` （行496: @warn "Error searching SSH known hosts file"）
- E-68: `stdlib/LibGit2/src/types.jl` （行1252: @warn "thrown exception"）
- E-69: `stdlib/Artifacts/src/Artifacts.jl` （行80, 137, 146, 160, 180: @error "Invalid override"）
- E-70: `stdlib/Artifacts/src/Artifacts.jl` （行283, 288, 418, 426: @error "Invalid artifacts file"）
- E-71: `base/deprecated.jl` （行215, 252: depwarn関数定義と@deprecateマクロ）
- E-72: `base/bitarray.jl`/`base/array.jl` （depwarn "passing Bool as an index is deprecated"）
- E-73: `base/download.jl` （行23: depwarn "Base.download is deprecated"）
- E-74: `base/loading.jl` （約20箇所: @debug "Rejecting cache file..."）
- E-75: `base/loading.jl` （行1456, 1460: @debug "Loading cache file"/"Loading object cache file"）
- E-76: `base/loading.jl` （行1765: @debug "Extension...loaded"）
- E-77: `base/loading.jl` （行3358, 3362: @debug "Generating cache file"/"Generating object cache file"）
- E-78: `base/file.jl` （行332: @debug "Could not delete DLL"）
- E-79: `stdlib/REPL/src/REPLCompletions.jl` （行373, 433: @debug "caching PATH files"）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ポータビリティ警告（devnullの代わりにファイルリダイレクト使用時） | E-01 | ○ |
| C-02 | 環境変数不正警告（malformed environment entry） | E-02 | ○ |
| C-03 | プロセスI/Oエラー警告 | E-03 | ○ |
| C-04 | 名前付き環境初期化失敗警告 | E-04 | ○ |
| C-05 | スレッド無効化フック失敗警告 | E-05 | ○ |
| C-06 | SecretBufferシュレッド警告 | E-06 | ○ |
| C-07 | プロジェクト読込失敗警告 | E-07 | ○ |
| C-08 | モジュール置換警告 | E-08 | ○ |
| C-09 | キャッシュモジュール不在警告 | E-09 | ○ |
| C-10 | プリコンパイルキャッシュ生成失敗警告 | E-10 | ○ |
| C-11 | 非アクティブプリコンパイル文警告 | E-11 | ○ |
| C-12 | 一時ディレクトリ不在警告 | E-12 | ○ |
| C-13 | 一時ファイルクリーンアップ失敗警告 | E-13 | ○ |
| C-14 | libgfortranバージョン検出失敗警告 | E-14 | ○ |
| C-15 | LLVMトリプル検出失敗警告 | E-15 | ○ |
| C-16 | 循環依存除外警告 | E-16 | ○ |
| C-17 | 不明コマンド警告 | E-17 | ○ |
| C-18 | InteractiveUtilsインポート失敗警告 | E-18 | ○ |
| C-19 | REPLインポート失敗警告 | E-19 | ○ |
| C-20 | ターミナル不完全警告 | E-20 | ○ |
| C-21 | REPLプロバイダ不在警告 | E-21 | ○ |
| C-22 | ドキュメント置換警告 | E-22 | ○ |
| C-23 | terminfo不正行警告 | E-23 | ○ |
| C-24 | 非推奨API使用警告（@get!） | E-24 | ○ |
| C-25 | ヒントハンドラエラー | E-25 | ○ |
| C-26 | GMP/MPFRビット不一致エラー | E-26 | ○ |
| C-27 | プロファイル印刷リスナークラッシュ | E-27 | ○ |
| C-28 | メソッド候補表示エラー | E-28 | ○ |
| C-29 | 一時ファイルクリーンアップエラー | E-29 | ○ |
| C-30 | 表示エラー通知 | E-30 | ○ |
| C-31 | display_errorエラー | E-31 | ○ |
| C-32 | 致命的エラー通知 | E-32 | ○ |
| C-33 | main戻り値エラー | E-33 | ○ |
| C-34 | パッケージコールバックエラー | E-34 | ○ |
| C-35 | 拡張機能ロードエラー | E-35 | ○ |
| C-36 | アクティブプロジェクトコールバックエラー | E-36 | ○ |
| C-37 | ネットワーク最適化警告（TCP_QUICKACK） | E-37 | ○ |
| C-38 | プロファイルバッファ制限警告（32ビット） | E-38 | ○ |
| C-39 | Windowsスレッドプロファイル制限警告 | E-39 | ○ |
| C-40 | プロファイルバッファ満杯警告 | E-40 | ○ |
| C-41 | ヒープスナップショット書込先変更警告 | E-41 | ○ |
| C-42 | ヒープスナップショット再構成バグ警告 | E-42 | ○ |
| C-43 | アロケーションプロファイル停止警告 | E-43 | ○ |
| C-44 | エディタ値不正警告 | E-44 | ○ |
| C-45 | BugReportingパッケージ読込通知 | E-45 | ○ |
| C-46 | BugReportingインストール試行通知 | E-46 | ○ |
| C-47 | ファイルシステム時刻ずれ警告 | E-47 | ○ |
| C-48 | 古いpidfile削除試行警告 | E-48 | ○ |
| C-49 | pidfile削除失敗警告 | E-49 | ○ |
| C-50 | REPL履歴ファイル不正警告 | E-50 | ○ |
| C-51 | 非公開シンボル使用警告 | E-51 | ○ |
| C-52 | 履歴ファイル無効化通知 | E-52 | ○ |
| C-53 | edit失敗通知 | E-53 | ○ |
| C-54 | キーマップエラー | E-54 | ○ |
| C-55 | SyntaxHighlightPassエラー | E-55 | ○ |
| C-56 | EnclosingParenHighlightPassエラー | E-56 | ○ |
| C-57 | ドキュメント検索不能警告 | E-57 | ○ |
| C-58 | TerminalMenus rawモード失敗警告 | E-58 | ○ |
| C-59 | マージレビュー通知 | E-59 | ○ |
| C-60 | Fast-Forwardマージ不能警告 | E-60 | ○ |
| C-61 | Fast-Forwardマージ不可警告 | E-61 | ○ |
| C-62 | リモートトラッキング未設定警告 | E-62 | ○ |
| C-63 | Git資格情報不明属性警告 | E-63 | ○ |
| C-64 | SSH既知ホストチェックエラー | E-64 | ○ |
| C-65 | トランスポート検証拒否エラー | E-65 | ○ |
| C-66 | SSH既知ホストファイル解析エラー警告 | E-66 | ○ |
| C-67 | SSH既知ホストファイル検索エラー警告 | E-67 | ○ |
| C-68 | LibGit2型例外警告 | E-68 | ○ |
| C-69 | Artifactsオーバーライド不正エラー | E-69 | ○ |
| C-70 | Artifactsファイル不正エラー | E-70 | ○ |
| C-71 | 非推奨関数使用警告（depwarn/@deprecate） | E-71 | ○ |
| C-72 | Bool引数インデックス非推奨警告 | E-72 | ○ |
| C-73 | download関数非推奨警告 | E-73 | ○ |
| C-74 | キャッシュファイル拒否デバッグ | E-74 | ○ |
| C-75 | キャッシュファイルロードデバッグ | E-75 | ○ |
| C-76 | 拡張機能ロードデバッグ | E-76 | ○ |
| C-77 | プリコンパイル生成デバッグ | E-77 | ○ |
| C-78 | DLL移動デバッグ | E-78 | ○ |
| C-79 | PATHファイルキャッシュデバッグ | E-79 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての通知はソースコード上の@warn/@info/@error/@debug/depwarnマクロの直接的な使用箇所から抽出しており、根拠なしの項目はありません。
- ただし、以下の点については網羅性に限界があります：
  - C言語ランタイム（src/）からjl_logmsg_shim経由で出力される通知は、Juliaソースコードレベルでは抽出が困難なため、一部未収録の可能性があります。
  - テストコード（test/）内の通知は、本番運用に関係ないため対象外としています。
  - ドキュメント内のサンプルコード（docs/）内の@warn等は対象外としています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての通知がソースコードの@warn/@info/@error/@debug/depwarnマクロの使用箇所から直接抽出されており、根拠は明確です。
- 1: 中リスク - C言語ランタイム層（src/ディレクトリ）からの通知が一部未収録の可能性があります。Juliaログシステム（logmsg_shim）を経由するものは存在しますが、直接stderr等に出力されるC言語レベルの警告は対象外です。
- 0: 低リスク - 通知のカテゴリ分類（Warn/Error/Info/Debug/非推奨通知）は、ソースコード上のマクロ種別に基づいており正確です。

## 6) レビュアーチェックリスト（最小）
- [ ] CSV内の全79件の通知が実際のソースコード上のマクロ使用箇所と一致しているか
- [ ] 通知のカテゴリ（Warn/Error/Info/Debug/非推奨通知）がマクロ種別と一致しているか
- [ ] 通知の説明が実際のメッセージ内容と整合しているか
- [ ] base/以外のstdlib/パッケージの通知が十分に網羅されているか
- [ ] C言語ランタイム層の通知の追加収録が必要かどうかの判断
