# 通知設計書 17-不明コマンド警告

## 概要

本ドキュメントは、Juliaのコマンドラインオプション処理において、予期しないコマンドライン引数が渡された場合に発行される警告通知（`@warn "Unexpected command"`）の設計仕様を記述する。

### 本通知の処理概要

本通知は、`exec_options`関数がコマンドライン引数を解析する際に、認識できないコマンド文字が検出された場合に警告を発行する処理である。

**業務上の目的・背景**：Juliaは起動時にコマンドライン引数を解析し、各オプションに応じた処理を実行する。認識できないコマンドが渡された場合、ユーザーの意図した操作が実行されない可能性があるため、早期に警告を通知する必要がある。これにより、タイプミスや非対応のオプションの使用を検出し、ユーザーが正しいオプションを使用できるよう支援する。

**通知の送信タイミング**：Juliaプロセス起動時の`exec_options`関数内で、`unsafe_load_commands(opts.commands)`から取得したコマンドリストを走査する際に、既知のコマンド文字（プログラム抑制コマンド、`'L'`、`'m'`、`'B'`）のいずれにも該当しないコマンドが検出された場合に送信される。

**通知の受信者**：Juliaプロセスを起動したユーザー。標準エラー出力を通じてログ表示される。

**通知内容の概要**：「Unexpected command -{コマンド文字}'{引数}'」というメッセージで、認識できなかったコマンド文字とその引数が含まれる。

**期待されるアクション**：ユーザーは、Juliaのコマンドラインヘルプ（`julia --help`）を参照し、正しいオプションを使用する。タイプミスの場合は修正して再実行する。

## 通知種別

ログ（Warn） - Juliaの標準ログシステム（`@warn`マクロ）を通じたコンソール警告出力

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（`@warn`マクロによる即座のログ出力） |
| 優先度 | 中（ユーザーの意図しない動作につながる可能性） |
| リトライ | なし |

### 送信先決定ロジック

Juliaの標準ロギングフレームワーク（`CoreLogging`）を通じて、現在アクティブなロガーに送信される。デフォルトでは標準エラー出力（`stderr`）に出力される。

## 通知テンプレート

### メール通知の場合

該当なし（コンソールログ出力のみ）

### 本文テンプレート

```
Warning: Unexpected command -{コマンド文字}'{引数}'
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| cmd | 認識できなかったコマンド文字 | `unsafe_load_commands(opts.commands)`の各要素の第1要素 | Yes |
| arg | コマンドに付随する引数文字列 | `unsafe_load_commands(opts.commands)`の各要素の第2要素 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| プロセス起動 | `exec_options(opts)`の実行 | コマンド文字が既知のいずれにも該当しない | `cmd_suppresses_program`, `'L'`, `'m'`, `'B'`以外のコマンド |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 認識済みコマンド | `cmd_suppresses_program(cmd)`がtrueを返すか、`cmd`が`'L'`、`'m'`、`'B'`のいずれかの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[exec_options呼出し] --> B[unsafe_load_commands]
    B --> C[コマンドリストの走査]
    C --> D{cmd_suppresses_program?}
    D -->|Yes| E[arg_is_program=false, repl=false]
    D -->|No| F{cmd == L or m?}
    F -->|Yes| G[スキップ]
    F -->|No| H{cmd == B?}
    H -->|Yes| I[バグレポート処理]
    H -->|No| J["@warn 'Unexpected command'"]
    E --> K[次のコマンドへ]
    G --> K
    J --> K
    K -->|残りあり| D
    K -->|完了| L[後続処理へ]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースを使用しない）

### 更新テーブル一覧

該当なし（データベースを使用しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 該当なし | 認識できないコマンドはエラーではなく警告として処理 | 警告を出力し、処理を続行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（プロセス起動時に1回のみ実行）

## セキュリティ考慮事項

通知にはコマンドライン引数の内容が含まれる。引数にパスワードやトークンなどの機密情報が含まれる場合、ログ出力に残る可能性があるため注意が必要である。

## 備考

- `exec_options`はJuliaプロセス起動時の最も初期段階で実行される
- `unsafe_load_commands`はCの構造体から安全でないメモリアクセスでコマンドリストを読み込む
- コマンド文字は単一の`Char`型で表現される
- 本警告が発行されても、プロセスの起動自体は中断されない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

コマンドラインオプション構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | client.jl | `base/client.jl` | `exec_options`関数の`opts`パラメータ - Cの`jl_options_t`構造体に対応 |

**読解のコツ**: `opts.commands`はC言語の構造体フィールドであり、`unsafe_load_commands`でJuliaのタプルリストに変換される。各要素は`(cmd::Char, arg::String)`のペア。

#### Step 2: エントリーポイントを理解する

`exec_options`関数のコマンド解析ループを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | client.jl | `base/client.jl` | `exec_options`関数（234行目）の全体構造 |
| 2-2 | client.jl | `base/client.jl` | 256-273行目のコマンド走査ループ |

**主要処理フロー**:
1. **256行目**: `cmds = unsafe_load_commands(opts.commands)` - コマンドリスト取得
2. **257行目**: `for (cmd, arg) in cmds` - 各コマンドを走査
3. **258行目**: `cmd_suppresses_program(cmd)` - プログラム抑制コマンドの判定
4. **261行目**: `cmd == 'L' || cmd == 'm'` - ロードパスとmainモジュール指定
5. **263行目**: `cmd == 'B'` - バグレポートコマンド
6. **271行目**: `@warn "Unexpected command -$cmd'$arg'"` - 認識できないコマンド

### プログラム呼び出し階層図

```
_start()                                [Juliaランタイム]
    |
    +-- exec_options(opts)              [base/client.jl:234]
            |
            +-- unsafe_load_commands()  [コマンドリスト読込]
            |
            +-- cmd_suppresses_program() [既知コマンド判定]
            |
            +-- @warn (条件付き)         [CoreLogging]
```

### データフロー図

```
[入力]                    [処理]                           [出力]

jl_options_t.commands --> unsafe_load_commands     --> [(cmd, arg), ...]
                          [client.jl:256]

(cmd, arg)ペア        --> if/elseif分岐            --> 各処理 or @warn
                          [client.jl:258-272]

不明コマンド          --> @warn文字列補間           --> stderr出力
                          [client.jl:271]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| client.jl | `base/client.jl` | ソース | コマンドラインオプション処理とフロントエンド |
| logging.jl | `base/logging.jl` | ソース | `@warn`マクロの定義 |
