# 通知設計書 18-InteractiveUtilsインポート失敗警告

## 概要

本ドキュメントは、JuliaのInteractiveUtilsモジュールのインポートに失敗した場合に発行される警告通知（`@warn "Failed to import InteractiveUtils"`）の設計仕様を記述する。

### 本通知の処理概要

本通知は、`load_InteractiveUtils`関数がInteractiveUtils標準ライブラリの読み込みを試行し、例外が発生した場合に警告を発行する処理である。InteractiveUtilsはREPLの依存パッケージであるため、この失敗はREPLの機能制限にもつながる。

**業務上の目的・背景**：InteractiveUtilsモジュールは、`@which`、`@edit`、`@code_warntype`、`methodswith`、`subtypes`、`report_bug`などの対話型開発支援機能を提供する標準ライブラリである。このモジュールのインポート失敗は、対話型セッションにおける開発効率の低下を意味する。本警告は、インポート失敗の原因（パッケージの破損、パスの問題等）をユーザーに通知し、問題の調査を促すために存在する。

**通知の送信タイミング**：`load_InteractiveUtils`関数内で`require_stdlib`を呼び出してInteractiveUtilsパッケージを読み込む際に例外が発生した場合に送信される。通常は対話型セッション開始時（`run_main_repl`から呼出される）または`--bug-report`オプション使用時に呼び出される。

**通知の受信者**：Juliaの対話型セッションを開始したユーザー。標準エラー出力を通じてログ表示される。

**通知内容の概要**：「Failed to import InteractiveUtils into module {モジュール名}」というメッセージとともに、発生した例外とそのバックトレースが付加情報として出力される。

**期待されるアクション**：ユーザーは、Juliaのインストールが正常であるか確認する。`LOAD_PATH`の設定、stdlibディレクトリの存在、パッケージの整合性を確認する。必要に応じてJuliaを再インストールする。

## 通知種別

ログ（Warn） - Juliaの標準ログシステム（`@warn`マクロ）を通じたコンソール警告出力

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（`@warn`マクロによる即座のログ出力） |
| 優先度 | 高（対話型開発機能の利用不可につながる） |
| リトライ | なし |

### 送信先決定ロジック

Juliaの標準ロギングフレームワーク（`CoreLogging`）を通じて、現在アクティブなロガーに送信される。デフォルトでは標準エラー出力（`stderr`）に出力される。

## 通知テンプレート

### メール通知の場合

該当なし（コンソールログ出力のみ）

### 本文テンプレート

```
Warning: Failed to import InteractiveUtils into module {モジュール名}
  exception = ({例外オブジェクト}, {バックトレース})
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| mod | インポート先のモジュール名 | `load_InteractiveUtils`関数の引数（デフォルト: `Main`） | Yes |
| exception | 発生した例外とバックトレースのタプル | `(ex, catch_backtrace())` | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| モジュールロード | `require_stdlib(PkgId(..., "InteractiveUtils"))`の実行 | 例外が発生した場合 | InteractiveUtils標準ライブラリのロードに失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既にロード済み | `isdefined(MainInclude, :InteractiveUtils)`がtrueの場合、require_stlibは実行されない |
| ロード成功 | `require_stdlib`が正常に完了した場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[load_InteractiveUtils呼出し] --> B{InteractiveUtils定義済み?}
    B -->|Yes| C[Core.eval using InteractiveUtils]
    B -->|No| D[try: require_stdlib InteractiveUtils]
    D -->|成功| E[MainInclude.InteractiveUtils に設定]
    D -->|例外| F["@warn 'Failed to import InteractiveUtils'"]
    E --> C
    F --> G[return nothing]
    C --> H[return InteractiveUtilsモジュール]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースを使用しない）

### 更新テーブル一覧

該当なし（データベースを使用しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| パッケージ未検出 | InteractiveUtils stdlibが見つからない | 警告を出力し`nothing`を返却。対話型機能は利用不可 |
| ロードエラー | パッケージのロード中にエラーが発生 | 警告を出力し`nothing`を返却。例外とバックトレースを表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（対話型セッション開始時に1回のみ呼出される）

## セキュリティ考慮事項

通知には例外メッセージとバックトレースが含まれ、ファイルパスやシステム構成情報が露出する可能性がある。ただし、これは対話型セッションのローカル出力であり、通常のセキュリティリスクは低い。

## 備考

- InteractiveUtilsのUUIDは`0xb77e0a4c_d291_57a0_90e8_8db25a27a240`
- `require_stdlib`は標準ライブラリ専用のロード関数で、通常の`require`とは異なる
- InteractiveUtilsはREPLの依存パッケージであるため、本警告が出ると通常REPLの機能も制限される
- `load_InteractiveUtils`は`run_main_repl`と`exec_options`の両方から呼出される可能性がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

MainIncludeモジュールとInteractiveUtilsの関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | client.jl | `base/client.jl` | `MainInclude`ベアモジュール（537行目付近）- InteractiveUtilsの格納先 |

**読解のコツ**: `MainInclude`はMainモジュールに弱い参照を提供するベアモジュール。`isdefined(MainInclude, :InteractiveUtils)`でロード済みかどうかを判定する。

#### Step 2: エントリーポイントを理解する

`load_InteractiveUtils`関数の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | client.jl | `base/client.jl` | `load_InteractiveUtils`（413-427行目）- ロード試行と例外処理 |

**主要処理フロー**:
1. **415行目**: `!isdefined(MainInclude, :InteractiveUtils)` - 未ロードの場合のみ処理
2. **417-418行目**: `require_stdlib(PkgId(UUID(...), "InteractiveUtils"))` - 標準ライブラリのロード
3. **419行目**: `MainInclude.InteractiveUtils = InteractiveUtils` - モジュール参照の格納
4. **421-423行目**: 例外発生時の`@warn`出力と`return nothing`
5. **426行目**: `Core.eval(mod, :(using ...))` - モジュールのusing実行

#### Step 3: 呼出し元を理解する

`load_InteractiveUtils`がどこから呼び出されるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | client.jl | `base/client.jl` | `run_main_repl`（515-534行目）内の`load_InteractiveUtils()`呼出し（518行目） |
| 3-2 | client.jl | `base/client.jl` | `exec_options`（234行目）内の`--bug-report`処理（266行目） |

### プログラム呼び出し階層図

```
run_main_repl(interactive, quiet, banner, history_file) [base/client.jl:515]
    |
    +-- load_InteractiveUtils()                          [base/client.jl:413]
    |       |
    |       +-- isdefined(MainInclude, :InteractiveUtils)
    |       +-- require_stdlib(PkgId(...))               [base/loading.jl]
    |       +-- Core.eval(mod, :(using ...))
    |       +-- @warn (例外時)                           [CoreLogging]
    |
    +-- load_REPL()                                      [base/client.jl:429]

exec_options(opts)                                       [base/client.jl:234]
    |
    +-- load_InteractiveUtils()  (--bug-report時)        [base/client.jl:266]
```

### データフロー図

```
[入力]                          [処理]                           [出力]

PkgId(UUID, "InteractiveUtils") --> require_stdlib       --> Moduleオブジェクト
                                     [base/loading.jl]       or 例外

Module                          --> MainInclude設定      --> MainInclude.InteractiveUtils
                                     [client.jl:419]

例外 + backtrace               --> @warn                --> stderr出力
                                     [client.jl:422]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| client.jl | `base/client.jl` | ソース | `load_InteractiveUtils`関数の定義 |
| loading.jl | `base/loading.jl` | ソース | `require_stdlib`関数の定義 |
| InteractiveUtils.jl | `stdlib/InteractiveUtils/src/InteractiveUtils.jl` | ソース | InteractiveUtilsモジュール本体 |
| logging.jl | `base/logging.jl` | ソース | `@warn`マクロの定義 |
