# 通知設計書 21-REPLプロバイダ不在警告

## 概要

本ドキュメントは、Julia言語ランタイムにおいて、REPLプロバイダが利用できず基本フォールバックREPLを使用する場合に出力される警告通知の設計を記述する。

### 本通知の処理概要

本通知は、Juliaのインタラクティブセッション開始時にREPL標準ライブラリが正常にロードできなかった場合に、基本的なフォールバックREPLを使用して動作を継続することをユーザーに警告するものである。

**業務上の目的・背景**：Juliaのインタラクティブモードでは、通常REPL標準ライブラリ（`REPL` stdlib）を読み込んで高機能なREPL（行編集、履歴、補完など）を提供する。しかし、パッケージのロードパスが不正、stdlib が破損、またはカスタムsysimageの不備などの理由でREPLモジュールの読み込みに失敗した場合、ユーザーに対してフォールバック状態にあることを通知する必要がある。この警告により、ユーザーは環境設定の問題を認識し、修正アクションを取ることができる。

**通知の送信タイミング**：Juliaプロセスがインタラクティブモードで起動し、`run_main_repl` 関数が呼ばれた際に、`REPL_MODULE_REF[]` が `Base` のままである（つまりREPLモジュールが正常にロードされていない）場合に発生する。具体的には `base/client.jl` の `run_main_repl` 関数内で条件判定される。

**通知の受信者**：Julia REPLを起動しようとしたユーザー（開発者、データサイエンティストなど）。stdoutに接続されたターミナル上でログとして表示される。

**通知内容の概要**：REPLプロバイダが利用できないこと、基本フォールバックREPLが代わりに使用されること、および現在の `LOAD_PATH` の値が表示される。`LOAD_PATH` を含めることで、問題の診断を容易にしている。

**期待されるアクション**：ユーザーは `LOAD_PATH` を確認し、Juliaのインストールが正しいこと、stdlibが正しいパスに存在することを検証する。必要に応じてJuliaを再インストールするか、環境変数 `JULIA_LOAD_PATH` や `JULIA_DEPOT_PATH` を修正する。

## 通知種別

ログ（Warn） -- Julia標準ロギングフレームワーク（`@warn` マクロ）によるコンソール出力

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（REPL起動プロセス内で即時出力） |
| 優先度 | 中（ログレベル Warn） |
| リトライ | 無し（ログ出力であるため） |

### 送信先決定ロジック

Julia の標準ロギングフレームワークに従い、`stderr` に出力される。`CoreLogging.ConsoleLogger` がデフォルトのグローバルロガーとして設定されている場合、警告メッセージはターミナルに表示される。カスタムロガーが設定されている場合はそのロガーの出力先に従う。

## 通知テンプレート

### メール通知の場合

該当なし（コンソールログ出力）

### 本文テンプレート

```
┌ Warning: REPL provider not available: using basic fallback
│   LOAD_PATH = "/path1:/path2:/path3"
└ @ Base client.jl:529
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| LOAD_PATH | 現在のJuliaロードパス | `Base.LOAD_PATH` をパス区切り文字で結合 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| プロセス起動 | `run_main_repl` 関数実行 | `!fallback_repl && interactive && REPL === Base && !quiet` | REPLモジュール未ロード、インタラクティブモード、quiet未設定の場合に送信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `quiet` が true | `julia --quiet` で起動した場合は抑止される |
| `fallback_repl` が true | 環境変数 `JULIA_FALLBACK_REPL=true` が設定されている場合は抑止される（意図的にフォールバックを使用しているため） |
| 非インタラクティブモード | スクリプト実行時など、REPLが不要な場合は `run_main_repl` 自体が呼ばれない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Julia起動・インタラクティブモード] --> B[run_main_repl呼び出し]
    B --> C{JULIA_FALLBACK_REPL=true?}
    C -->|Yes| D[フォールバックREPL起動・警告なし]
    C -->|No| E[load_InteractiveUtils実行]
    E --> F{REPL_MODULE_REF == Base?}
    F -->|Yes| G[load_REPL実行]
    F -->|No| H[標準REPL起動]
    G --> I{REPL_MODULE_REF == Base?}
    I -->|Yes| J{interactive && !quiet?}
    I -->|No| H
    J -->|Yes| K[@warn 出力]
    J -->|No| L[フォールバックREPL起動・警告なし]
    K --> M[フォールバックREPL起動]
    H --> N[終了]
    D --> N
    L --> N
    M --> N
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースを使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ログ出力失敗 | stderr が閉じている場合 | Julia ランタイムのデフォルトエラー処理に委ねる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（プロセス起動時に1回のみ発生） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（プロセス起動時に即時出力）

## セキュリティ考慮事項

`LOAD_PATH` の値がログに含まれるため、ファイルシステム構造の一部が露出する。ただし、これは通常のデバッグ情報であり、機密情報ではない。マルチユーザー環境では、ログ出力先のアクセス権限に注意が必要。

## 備考

- `JULIA_FALLBACK_REPL` 環境変数を `true` に設定すると、最初からフォールバックREPLを使用し、この警告は発生しない
- この警告が発生する一般的な原因は、Juliaのインストールが不完全であるか、`JULIA_LOAD_PATH` が不正に設定されている場合である
- フォールバックREPLは行編集、タブ補完、履歴機能が制限されるため、ユーザー体験が大幅に低下する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、REPL起動に関わる主要なグローバル変数と定数を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Base.jl | `base/Base.jl` | 16行目: `REPL_MODULE_REF` の定義。`Ref{Module}(Base)` として初期化され、REPLモジュールロード後に更新される |
| 1-2 | client.jl | `base/client.jl` | 6-14行目: カラー定義とREPLの基本設定 |

**読解のコツ**: `REPL_MODULE_REF` は `Ref{Module}` 型であり、初期値は `Base` モジュール自身。REPLモジュールが正常にロードされると、REPL stdlibがこの参照を自身に更新する。

#### Step 2: エントリーポイントを理解する

処理の起点は `_start` 関数であり、そこから `repl_main` → `run_main_repl` と呼び出される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | client.jl | `base/client.jl` | 575-613行目: `_start` 関数。プログラム全体のエントリーポイント |
| 2-2 | client.jl | `base/client.jl` | 615-627行目: `repl_main` 関数。REPL起動オプションの処理 |

**主要処理フロー**:
1. **575行目**: `_start()` が呼ばれる
2. **585行目**: `exec_options` でコマンドラインオプション処理
3. **596行目**: `repl_main(ARGS)` でREPL起動
4. **626行目**: `run_main_repl` に制御が移る

#### Step 3: 通知発生箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | client.jl | `base/client.jl` | 515-534行目: `run_main_repl` 関数。警告の発生箇所 |
| 3-2 | client.jl | `base/client.jl` | 429-437行目: `load_REPL` 関数。REPLモジュールのロード試行 |
| 3-3 | client.jl | `base/client.jl` | 413-427行目: `load_InteractiveUtils` 関数 |
| 3-4 | client.jl | `base/client.jl` | 442-482行目: `run_fallback_repl` 関数。フォールバックREPLの実装 |

**主要処理フロー**:
- **516行目**: `JULIA_FALLBACK_REPL` 環境変数をチェック
- **518行目**: `load_InteractiveUtils()` を呼び出し
- **519-522行目**: `REPL_MODULE_REF` が Base のままなら `load_REPL()` を試行
- **525行目**: REPL ロード成功なら `run_std_repl` へ
- **528-529行目**: REPL ロード失敗時、`@warn "REPL provider not available: using basic fallback"` を出力
- **531行目**: `run_fallback_repl` でフォールバック動作

### プログラム呼び出し階層図

```
_start() [client.jl:575]
    │
    ├─ exec_options() [client.jl:234]
    │
    └─ repl_main() [client.jl:615]
           │
           └─ run_main_repl() [client.jl:515]
                  │
                  ├─ load_InteractiveUtils() [client.jl:413]
                  │      └─ require_stdlib() [loading.jl]
                  │
                  ├─ load_REPL() [client.jl:429]
                  │      └─ require_stdlib() [loading.jl]
                  │
                  ├─ @warn "REPL provider not available..." [client.jl:529]
                  │
                  ├─ run_std_repl() [client.jl:484]  (成功時)
                  │
                  └─ run_fallback_repl() [client.jl:442]  (失敗時)
```

### データフロー図

```
[入力]                       [処理]                          [出力]

環境変数                 ┌─ JULIA_FALLBACK_REPL チェック
JULIA_FALLBACK_REPL ──▶ │
                        │
REPL_MODULE_REF ──────▶ ├─ load_REPL() 試行 ────▶ REPL モジュール or Base
                        │
Base.LOAD_PATH ───────▶ ├─ 条件判定 ─────────────▶ @warn メッセージ ──▶ stderr
                        │
JLOptions (quiet) ────▶ └─ quiet チェック
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| client.jl | `base/client.jl` | ソース | 通知の発生元。REPL起動ロジック全体を含む |
| Base.jl | `base/Base.jl` | ソース | `REPL_MODULE_REF` の定義 |
| loading.jl | `base/loading.jl` | ソース | `require_stdlib` 関数の実装（REPLモジュールロード） |
| logging.jl | `base/logging/logging.jl` | ソース | `@warn` マクロの実装 |
