# 通知設計書 28-メソッド候補表示エラー

## 概要

本ドキュメントは、Juliaの `MethodError` 表示処理中に、メソッド候補の表示が失敗した場合に出力されるエラー通知の設計を記述する。

### 本通知の処理概要

本通知は、`showerror(io::IO, ex::MethodError)` 関数内で `show_method_candidates` の呼び出しが例外をスローした場合に出力されるエラーログである。

**業務上の目的・背景**：`MethodError` が発生した際、Juliaはユーザーの助けとなるよう、呼び出し候補となるメソッドのリストを表示する。しかし、`show_method_candidates` 自体が内部エラーを起こす可能性がある（例: 型情報の表示中のエラー、反射APIの問題など）。エラー表示中のさらなるエラーが全体のエラー報告を壊さないよう、この部分は try-catch で保護されており、失敗した場合はエラーログとして記録した上でエラー表示を完了させる。

**通知の送信タイミング**：`showerror` 内で `show_method_candidates(io, ex, kwargs)` が例外をスローした際に発生する。

**通知の受信者**：Julia開発者。コンソール（stderr）に表示される。

**通知内容の概要**：「Error showing method candidates, aborted」というメッセージとともに、例外オブジェクトとバックトレースが出力される。

**期待されるアクション**：Julia開発者が `show_method_candidates` 関数の実装を調査し、バグを修正する。

## 通知種別

ログ（Error） -- Julia標準ロギングフレームワーク（`@error` マクロ）によるコンソール出力

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（エラー表示処理中に即時出力） |
| 優先度 | 高（ログレベル Error） |
| リトライ | 無し |

### 送信先決定ロジック

Julia の標準ロギングフレームワークに従い、`stderr` に出力される。

## 通知テンプレート

### メール通知の場合

該当なし（コンソールログ出力）

### 本文テンプレート

```
┌ Error: Error showing method candidates, aborted
│   exception =
│    {exception object}
│    Stacktrace:
│     [1] ...
└ @ Base errorshow.jl:401
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| exception | 捕捉された例外とバックトレース | `ex, catch_backtrace()` | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| エラー表示 | `showerror(io, ex::MethodError)` 内の `show_method_candidates` 呼び出し | 任意の例外がスローされた場合 | メソッド候補表示中の例外 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `show_method_candidates` が正常完了 | 例外が発生しなければ通知なし |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A["MethodError 発生"] --> B["showerror(io, ex::MethodError)"]
    B --> C["エラーメッセージ本体の表示"]
    C --> D["Experimental.show_error_hints 呼び出し"]
    D --> E["try: show_method_candidates(io, ex, kwargs)"]
    E --> F{"例外発生?"}
    F -->|No| G["正常完了"]
    F -->|Yes| H["@error 出力"]
    H --> G
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| メソッド候補表示例外 | `show_method_candidates` 内の任意のエラー | `@error` ログを出力し、`showerror` を正常に終了させる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | なし（MethodError 表示ごとに発生し得る） |

### 配信時間帯

制限なし

## セキュリティ考慮事項

例外オブジェクトとバックトレースがログに含まれる。内部的な型情報やメソッドテーブルの状態が露出する可能性があるが、これはデバッグ目的の情報である。

## 備考

- `show_method_candidates` は比較的複雑な処理（メソッドテーブルの走査、型の比較と表示）を行うため、エラーが発生する可能性がある
- この try-catch は `showerror` の他の部分（エラーメッセージ本体、ヒント表示）には影響しない
- `catch ex` の `ex` 変数は外側の `MethodError` と同名のため、catch ブロック内では元の `MethodError` にはアクセスできない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | errorshow.jl | `base/errorshow.jl` | `MethodError` 型の構造（`f`, `args`, `world` フィールド） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | errorshow.jl | `base/errorshow.jl` | `showerror(io::IO, ex::MethodError)` 関数。MethodError の表示全体 |

#### Step 3: 通知発生箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | errorshow.jl | `base/errorshow.jl` | 397行目: `Experimental.show_error_hints` 呼び出し（ヒント表示） |
| 3-2 | errorshow.jl | `base/errorshow.jl` | 398-402行目: try-catch ブロック。`show_method_candidates` の保護 |
| 3-3 | errorshow.jl | `base/errorshow.jl` | 401行目: `@error "Error showing method candidates, aborted"` |

**主要処理フロー**:
- **397行目**: ヒントハンドラを呼び出し（別途保護されている）
- **398行目**: `try` ブロック開始
- **399行目**: `show_method_candidates(io, ex, kwargs)` 呼び出し
- **400行目**: `catch ex` で例外をキャッチ
- **401行目**: `@error "Error showing method candidates, aborted" exception=ex,catch_backtrace()` でエラー出力
- **403行目**: `nothing` を返して `showerror` を正常終了

### プログラム呼び出し階層図

```
showerror(io, ex::MethodError) [errorshow.jl]
    │
    ├─ ... (エラーメッセージ本体の表示)
    │
    ├─ Experimental.show_error_hints(io, ex, ...) [errorshow.jl:397]
    │
    └─ try [errorshow.jl:398]
           │
           ├─ show_method_candidates(io, ex, kwargs) [errorshow.jl:399]
           │
           └─ catch ex [errorshow.jl:400]
                  │
                  └─ @error "Error showing method candidates, aborted" [errorshow.jl:401]
```

### データフロー図

```
[入力]                           [処理]                         [出力]

MethodError (ex) ──────────────▶ showerror
  ex.f ──────────────────────────▶ メソッド情報解析
  ex.args ────────────────────────▶ 引数型解析
                                 │
                                 ├─ show_method_candidates ───▶ メソッド候補リスト ──▶ io
                                 │     │
                                 │     └─ 例外発生 ──────────▶ @error ──▶ stderr
                                 │
                                 └─ nothing (return)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| errorshow.jl | `base/errorshow.jl` | ソース | 通知の発生元。`showerror(MethodError)` と `show_method_candidates` |
| experimental.jl | `base/experimental.jl` | ソース | `show_error_hints` 関数（メソッド候補表示の直前に呼ばれる） |
| logging.jl | `base/logging/logging.jl` | ソース | `@error` マクロの実装 |
