# 通知設計書 32-致命的エラー通知

## 概要

本ドキュメントは、Julia REPL の対話型評価ループにおいて、エラー表示が連続して失敗し、システムの重要なコンポーネントが破損している可能性がある場合に出力される致命的エラー通知の設計を記述する。

### 本通知の処理概要

本通知は、`eval_user_input` 関数内のエラー処理ループで `errcount > 2` に達した際に発行されるシステムレベルの致命的エラー通知である。

**業務上の目的・背景**：Julia の REPL ではユーザー入力の評価中にエラーが発生した場合、エラー表示を試みる。しかし、エラー表示自体が繰り返し失敗する場合（例：IO システムの破損、表示メソッドの無限再帰など）、システムが正常に動作できない状態にあることを示す。この通知は、そうした深刻な障害をユーザーと開発者に伝え、REPL ループを安全に終了させる役割を持つ。

**通知の送信タイミング**：`eval_user_input` 関数内の `catch` ブロックにおいて、`errcount` が 2 を超えた（3回以上のエラー表示失敗が連続した）時点で送信される。具体的には `base/client.jl` の167行目で発火する。

**通知の受信者**：Julia プロセスの標準エラー出力 (stderr) を監視する開発者・運用者。ログレベルは `Error`。

**通知内容の概要**：`"It is likely that something important is broken, and Julia will not be able to continue normally"` というメッセージと共に、現在の `errcount` 値がキーワード引数として出力される。

**期待されるアクション**：受信者は Julia のシステムコンポーネント（IO、表示メソッド、メモリ状態など）に深刻な問題があることを認識する。REPL ループは本通知の後に `break` で終了するため、Julia プロセスの再起動やデバッグモードでの調査が必要となる。

## 通知種別

ログ（Error） -- Julia の標準ログシステム（`@error` マクロ）による stderr へのエラーレベル出力

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（`@error` マクロによる即座のログ出力） |
| 優先度 | 最高（致命的エラー） |
| リトライ | 無し（本通知自体のリトライはない） |

### 送信先決定ロジック

Julia の標準ログシステムにより、現在アクティブなログハンドラに送信される。REPL 環境では stderr に直接出力される。

## 通知テンプレート

### メール通知の場合

該当なし（本通知はログ出力であり、メール送信は行わない）

### 本文テンプレート

```
It is likely that something important is broken, and Julia will not be able to continue normally
  errcount = {errcount}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| errcount | エラー表示の連続失敗回数 | `eval_user_input` 関数内のローカル変数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| REPL評価ループ | `display_error` の呼び出しが連続して失敗 | `errcount > 2` | 3回以上のエラー表示失敗でシステムが破損と判断 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `errcount <= 2` | エラー回数が閾値以下の場合はリトライを続行 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[eval_user_input: エラー表示リトライループ] --> B{errcount > 2 か}
    B -->|No| C[errcount += 1, lasterr 更新してリトライ]
    B -->|Yes| D["@error 致命的エラー通知発行"]
    D --> E[break でループ終了]
    E --> F[println で改行出力]
    F --> G[eval_user_input 関数終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 致命的エラー到達 | errcount > 2 | REPL ループを break で安全に終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無し（本通知はリトライの最終段階で発行される） |
| リトライ間隔 | -- |
| リトライ対象エラー | -- |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

本通知は errcount 値のみを含む固定メッセージであり、機密情報は含まない。

## 備考

- 本通知（No.32）は No.31「display_error エラー」の後段階として発生する。errcount = 1 で No.31 が発火し、errcount = 3 で本通知が発火する。
- 本通知の発行後、REPL ループは `break` で終了するが、Julia プロセス自体は終了しない（呼び出し元に制御が戻る）。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | client.jl | `base/client.jl` | `eval_user_input` 関数内のローカル変数 `errcount`（128行目）と `lasterr`（129行目）の役割を理解する |

**読解のコツ**: `errcount` は連続エラー表示失敗の回数を追跡し、閾値超過で致命的エラーを判定するカウンタである。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | client.jl | `base/client.jl` | `eval_user_input` 関数（127-174行目）の `catch` ブロック、特に166-169行目 |

**主要処理フロー**:
1. **159行目**: `catch` で例外をキャッチ
2. **160-162行目**: `errcount > 0` の場合に No.31 通知を発行
3. **163行目**: `errcount += 1`
4. **166行目**: `errcount > 2` の条件判定
5. **167行目**: `@error "It is likely that something important is broken..."` を発行
6. **168行目**: `break` でループ終了

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | client.jl | `base/client.jl` | `run_fallback_repl`（442-482行目）と `_start`（575-613行目）からの呼び出し経路 |

**主要処理フロー**:
- **474行目**: `run_fallback_repl` 内で `eval_user_input(stderr, ex, true)` が呼ばれる
- **575行目**: `_start` が Julia 起動時のエントリーポイント

### プログラム呼び出し階層図

```
_start() [base/client.jl:575]
    |
    +-- exec_options() [base/client.jl:234]
    |       |
    |       +-- run_main_repl() [base/client.jl:515]
    |               |
    |               +-- run_fallback_repl() [base/client.jl:442]
    |                       |
    |                       +-- eval_user_input() [base/client.jl:127]
    |                               |
    |                               +-- catch ブロック [行159]
    |                                       |
    |                                       +-- @error (No.31) [行161]
    |                                       +-- errcount チェック [行166]
    |                                       +-- @error (No.32 本通知) [行167]
    |                                       +-- break [行168]
```

### データフロー図

```
[入力]                    [処理]                          [出力]

エラー表示失敗 -------> eval_user_input catch ブロック
(3回連続)                   |
                            +-- errcount > 2 判定
                            |       |
                            |       +--> @error ログ --> stderr
                            |       +--> break --> ループ終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| client.jl | `base/client.jl` | ソース | REPL フロントエンド処理、`eval_user_input` 関数の定義 |
| logging.jl | `base/logging.jl` | ソース | `@error` マクロの定義 |
| errorshow.jl | `base/errorshow.jl` | ソース | `display_error` 関数と `showerror` の定義 |
