# 通知設計書 37-ネットワーク最適化警告

## 概要

本ドキュメントは、Linux システムにおいて TCP_QUICKACK ソケットオプションの有効化に失敗した場合に出力されるネットワーク最適化警告の設計を記述する。

### 本通知の処理概要

本通知は、`quickack` 関数内で TCP_QUICKACK オプションの設定が失敗した場合にワーニングレベルのログを出力する処理である。

**業務上の目的・背景**：TCP_QUICKACK は Linux 固有のソケットオプションで、TCP の遅延 ACK（Delayed ACK）を無効化し、応答の遅延を減らすネットワーク最適化機能である。このオプションの設定に失敗した場合、ネットワーク通信自体は正常に動作するが、パフォーマンスが最適化されていない状態となる。本通知は、この非最適化状態をユーザーに知らせるために設けられている。

**通知の送信タイミング**：`quickack` 関数内で `ccall(:jl_tcp_quickack, ...)` の戻り値が負（エラー）の場合に送信される。具体的には `stdlib/Sockets/src/Sockets.jl` の616行目で発火する。

**通知の受信者**：Julia プロセスの標準エラー出力 (stderr) を監視する開発者・運用者。ログレベルは `Warn`。

**通知内容の概要**：`"Networking unoptimized ( Error enabling TCP_QUICKACK : {errno メッセージ} )"` という警告メッセージが出力される。`maxlog=1` により、同一メッセージは最大1回のみ出力される。

**期待されるアクション**：受信者はシステムのネットワーク設定やカーネルバージョンを確認する。TCP_QUICKACK はパフォーマンス最適化であり、設定失敗はアプリケーションの動作に影響しないため、即座のアクションは必須ではない。

## 通知種別

ログ（Warn） -- Julia の標準ログシステム（`@warn` マクロ）による stderr への警告レベル出力

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（`@warn` マクロによる即座のログ出力） |
| 優先度 | 低 |
| リトライ | 無し |

### 送信先決定ロジック

Julia の標準ログシステムにより、現在アクティブなログハンドラに送信される。`maxlog=1` により重複出力は抑制される。

## 通知テンプレート

### メール通知の場合

該当なし（本通知はログ出力であり、メール送信は行わない）

### 本文テンプレート

```
Networking unoptimized ( Error enabling TCP_QUICKACK : {errno_message} )
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| errno_message | システムエラーメッセージ | `Libc.strerror(Libc.errno())` | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ソケット操作 | `quickack` 関数の呼び出し | `jl_tcp_quickack` の戻り値が負 かつ Linux システム | `@static if Sys.islinux()` で条件分岐 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Linux 以外のシステム | `@static if Sys.islinux()` により、Linux 以外では quickack の設定自体が行われない |
| 設定が成功 | `jl_tcp_quickack` の戻り値が 0 以上の場合、本通知は発生しない |
| `maxlog=1` | 2回目以降の同一エラーは出力されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A["quickack(sock, enable) 呼び出し"] --> B["iolock_begin()"]
    B --> C["check_open(sock)"]
    C --> D{"Sys.islinux() か"}
    D -->|No| E["何もしない"]
    D -->|Yes| F["ccall(:jl_tcp_quickack, ...)"]
    F --> G{"戻り値 < 0 か"}
    G -->|No| H["設定成功"]
    G -->|Yes| I["@warn ネットワーク最適化警告"]
    I --> J["iolock_end()"]
    H --> J
    E --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| TCP_QUICKACK 設定失敗 | `jl_tcp_quickack` がエラーコードを返す | @warn 通知を発行、ソケット操作自体は続行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無し |
| リトライ間隔 | -- |
| リトライ対象エラー | -- |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | `maxlog=1` により最大1回 |
| 1日あたり上限 | 同上 |

### 配信時間帯

制限なし

## セキュリティ考慮事項

本通知はシステムのエラーメッセージ（errno の文字列表現）を含むが、通常は機密情報を含まない。

## 備考

- TCP_QUICKACK は Linux 固有のオプションであり、他の OS（macOS, Windows, BSD）では本通知は発生しない。
- `@static if Sys.islinux()` によりコンパイル時に条件分岐が行われるため、Linux 以外のビルドでは関連コードがバイナリに含まれない。
- `quickack` 関数はドキュメント上で "On Linux systems" と明記されており、プラットフォーム依存の最適化関数である。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Sockets.jl | `stdlib/Sockets/src/Sockets.jl` | `TCPSocket` 構造体（58-82行目）と `TCPServer` 構造体（113-127行目）を理解する |

**読解のコツ**: `TCPSocket` と `TCPServer` は `LibuvStream` / `LibuvServer` のサブタイプで、`handle` フィールドに libuv のハンドルポインタを持つ。`quickack` 関数はこれらの `handle` を通じて OS のソケットオプションを設定する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Sockets.jl | `stdlib/Sockets/src/Sockets.jl` | `quickack` 関数（610-621行目）が本通知のエントリーポイント |

**主要処理フロー**:
1. **611行目**: `iolock_begin()` で IO ロックを取得
2. **612行目**: `check_open(sock)` でソケットの状態を確認
3. **613行目**: `@static if Sys.islinux()` で Linux 判定
4. **615行目**: `ccall(:jl_tcp_quickack, Cint, ...)` で TCP_QUICKACK を設定
5. **616行目**: 戻り値が負の場合に `@warn` で本通知を発行
6. **619行目**: `iolock_end()` で IO ロックを解放

### プログラム呼び出し階層図

```
ユーザーコード / 内部コード
    |
    +-- quickack(sock, enable) [stdlib/Sockets/src/Sockets.jl:610]
            |
            +-- iolock_begin() [行611]
            +-- check_open(sock) [行612]
            +-- @static if Sys.islinux() [行613]
            |       |
            |       +-- ccall(:jl_tcp_quickack, ...) [行615]
            |               |
            |               +-- 失敗時: @warn (No.37 本通知) [行616]
            |
            +-- iolock_end() [行619]
```

### データフロー図

```
[入力]                    [処理]                          [出力]

sock (TCPSocket/Server)
enable (Bool) ----------> quickack()
                            |
                            +-- ccall(:jl_tcp_quickack)
                            |       |
                            |       +-- 成功 --> ソケットオプション設定完了
                            |       +-- 失敗 --> @warn ログ --> stderr
                            |               (errno メッセージ付き)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Sockets.jl | `stdlib/Sockets/src/Sockets.jl` | ソース | ソケット操作モジュール、`quickack` 関数の定義 |
| logging.jl | `base/logging.jl` | ソース | `@warn` マクロの定義 |
