# 通知設計書 39-Windowsスレッドプロファイル制限警告

## 概要

本ドキュメントは、Windows 環境においてプロファイリング結果がメインスレッドに限定される場合に出力される警告通知の設計を記述する。

### 本通知の処理概要

本通知は、`Profile.print` 関数でプロファイル結果を `groupby` オプションのスレッド関連グルーピングで表示しようとした際に、Windows 環境ではメインスレッドのみがサンプリングされていることをユーザーに警告する処理である。

**業務上の目的・背景**：Windows の Julia プロファイラーは、技術的な制約によりメインスレッドのみからサンプルを収集する。マルチスレッドプログラムで `:thread` や `[:task, :thread]`、`[:thread, :task]` のグルーピングオプションを使用した場合、他のスレッドのデータが表示されないことをユーザーに明示する必要がある。本通知はその情報を提供するために設けられている。

**通知の送信タイミング**：`Profile.print` 関数内で `groupby` オプションがスレッド関連（`:thread`, `[:task, :thread]`, `[:thread, :task]`）であり、かつ `Sys.iswindows()` が `true` の場合に送信される。具体的には `stdlib/Profile/src/Profile.jl` の294行目で発火する。

**通知の受信者**：Julia プロセスの標準エラー出力 (stderr) を監視する開発者。ログレベルは `Warn`。

**通知内容の概要**：`"Profiling on windows is limited to the main thread. Other threads have not been sampled and will not show in the report"` という警告メッセージが出力される。

**期待されるアクション**：開発者はプロファイル結果がメインスレッドのみであることを理解し、マルチスレッドのパフォーマンス分析が必要な場合は Linux や macOS 環境でのプロファイリングを検討する。

## 通知種別

ログ（Warn） -- Julia の標準ログシステム（`@warn` マクロ）による stderr への警告レベル出力

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（`@warn` マクロによる即座のログ出力） |
| 優先度 | 低 |
| リトライ | 無し |

### 送信先決定ロジック

Julia の標準ログシステムにより、現在アクティブなログハンドラに送信される。

## 通知テンプレート

### メール通知の場合

該当なし（本通知はログ出力であり、メール送信は行わない）

### 本文テンプレート

```
Profiling on windows is limited to the main thread. Other threads have not been sampled and will not show in the report
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| （なし） | 本通知は固定文字列のみ | -- | -- |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| プロファイル表示 | `Profile.print` にスレッド関連 `groupby` オプションが指定された | `Sys.iswindows()` かつ `groupby` が `:thread`, `[:task, :thread]`, `[:thread, :task]` のいずれか | `print` 関数内の条件分岐で検出 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Windows 以外のシステム | Linux/macOS では本制限はない |
| `groupby` が `:none` または `:task` | スレッドグルーピングが不要な場合は本通知は発生しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A["Profile.print(io; groupby=...) 呼び出し"] --> B{"groupby が :none か"}
    B -->|Yes| C["グルーピングなしで表示"]
    B -->|No| D{"groupby が有効な値か"}
    D -->|No| E["ArgumentError"]
    D -->|Yes| F{"Sys.iswindows() かつスレッド関連か"}
    F -->|Yes| G["@warn Windows スレッドプロファイル制限警告"]
    F -->|No| H["通常のグルーピング表示"]
    G --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 無効な groupby 値 | 未知の groupby オプション | ArgumentError をスロー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無し |
| リトライ間隔 | -- |
| リトライ対象エラー | -- |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（`Profile.print` 呼び出しごとに発生し得る） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

本通知は固定メッセージのみを出力し、機密情報は含まない。

## 備考

- この制限は Windows の Julia プロファイラー実装に起因する。`@profile` マクロ自体はメインスレッドからのみサンプルを収集する。
- `Profile.print` の docstring にも `"Profiling on windows is limited to the main thread."` と明記されている（267-268行目のノート）。
- プロファイル結果の表示自体は行われるが、メインスレッドのデータのみが含まれる。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Profile.jl | `stdlib/Profile/src/Profile.jl` | `META_OFFSET_THREADID` 定数（218行目）とメタデータ構造を理解する |

**読解のコツ**: プロファイルデータの各ブロックにはメタデータ（スレッドID、タスクID、CPUサイクルクロック、スリープ状態）が含まれる。Windows ではメインスレッドのみのスレッドIDが記録される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Profile.jl | `stdlib/Profile/src/Profile.jl` | `print` 関数（271-361行目）の `groupby` 処理部分が本通知のエントリーポイント |

**主要処理フロー**:
1. **288行目**: `groupby === :none` のチェック
2. **291行目**: groupby 値のバリデーション
3. **293行目**: `Sys.iswindows()` かつスレッド関連 groupby のチェック
4. **294行目**: `@warn` で本通知を発行
5. **296-358行目**: 各 groupby オプションに応じたデータの表示

### プログラム呼び出し階層図

```
Profile.print(io; groupby=:thread) [stdlib/Profile/src/Profile.jl:271]
    |
    +-- groupby バリデーション [行291]
    +-- Sys.iswindows() チェック [行293]
    |       |
    |       +-- @warn (No.39 本通知) [行294]
    |
    +-- get_thread_ids(data) [行320]
    +-- print_group(io, data, ...) [行331/353]
```

### データフロー図

```
[入力]                    [処理]                          [出力]

data (プロファイルデータ)
groupby (Symbol) -------> Profile.print()
                            |
                            +-- groupby 検証
                            |       |
                            |       +-- Windows & スレッド関連
                            |               |
                            |               +--> @warn ログ --> stderr
                            |
                            +-- データ表示 --> io
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Profile.jl | `stdlib/Profile/src/Profile.jl` | ソース | プロファイルモジュール、`print` 関数の定義 |
| logging.jl | `base/logging.jl` | ソース | `@warn` マクロの定義 |
